/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.storage.impl;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.ps.DAO.SubCatGroupDAO;
import org.exoplatform.ps.entity.SubCatGroupEntity;
import org.exoplatform.ps.storage.api.SubCatGroupRelationStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.storage.impl.AbstractStorage;

public class SubCatGroupRelationStorageImpl
extends AbstractStorage
implements SubCatGroupRelationStorage {
    private static final Log LOG = ExoLogger.getLogger(SubCatGroupRelationStorageImpl.class);
    private SubCatGroupDAO subCatGroupDAO;

    public SubCatGroupRelationStorageImpl(SubCatGroupDAO subCatGroupDAO) {
        this.subCatGroupDAO = subCatGroupDAO;
    }

    @Override
    public SubCatGroupEntity createSubCatGroupRelation(String subGroupId, String subCatId, String subId, String subName, String catId, String catName, String groupName) throws Exception {
        SubCatGroupEntity rel = new SubCatGroupEntity();
        subCatId = subId + "_" + catId;
        rel.getSubCat().setId(subCatId);
        rel.setId(subGroupId + "_" + subCatId);
        rel.getSubGroup().setId(subGroupId);
        rel.getCategory().setId(catId);
        rel.getSubContractor().setId(subId);
        rel.getSubContractor().setDisplayName(subName);
        rel.getCategory().setFieldName(catName);
        rel.getSubGroup().setSubGroupName(groupName);
        return (SubCatGroupEntity)this.subCatGroupDAO.create(rel);
    }

    @Override
    public void deleteSubCatGroupRelation(String id) throws Exception {
        SubCatGroupEntity subCatGroupEntity = (SubCatGroupEntity)this.subCatGroupDAO.find((Serializable)((Object)id));
        this.subCatGroupDAO.delete(subCatGroupEntity);
    }

    @Override
    public List<SubCatGroupEntity> getRelationShipBySubCatId(String subCatId, int offset, int limit) throws Exception {
        return this.subCatGroupDAO.getRelationShipBySubCatId(subCatId, offset, limit);
    }

    @Override
    public List<SubCatGroupEntity> getRelationShipBySubGroupId(String subGroupId, int offset, int limit) throws Exception {
        return this.subCatGroupDAO.getRelationShipBySubGroupId(subGroupId, offset, limit);
    }

    @Override
    public List<SubCatGroupEntity> getRelationShipBySubId(String subId, int offset, int limit) throws Exception {
        return this.subCatGroupDAO.getRelationShipBySubId(subId, offset, limit);
    }
}

