/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.pulse.service.ws;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="ForumParticipant")
public class RestForumParticipant
implements ResourceContainer {
    private static final String FILTER_BY_WEEK = "week";
    private static final String FILTER_BY_MONTH = "month";
    private static final String FILTER_BY_YEAR = "year";
    private static final SimpleDateFormat formatDateTime = new SimpleDateFormat();
    private static final String TIME_FORMAT_TAIL_TO = "T23:59:59.999";
    private static final String TIME_FORMAT_TAIL_FROM = "T00:00:00.000";
    private final long DAY_IN_MILLISEC = 86400000L;
    public static final String POST_CREATED_DATE = "exo:createdDate";
    public static final String POST_NODE_TYPE = "exo:post";
    private RepositoryService repositoryService;
    private ForumService forumService = (ForumService)CommonsUtils.getService(ForumService.class);
    private IdentityManager identityManager;
    private static final Log LOG = ExoLogger.getLogger(RestForumParticipant.class);
    private static final CacheControl cacheControl;
    private static List<String> forumParticipantsBeanTempCacheKeyQueue;
    private static Map<String, ForumParticipantsBean> forumParticipantsBeanTempCache;
    private static final int MAX_SIZE_FORUM_PARTICIPANT_BEAN_TEMP_CACHE = 100;
    private static final int MAX_RESULT = 20;

    public RestForumParticipant() {
        this.repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
        this.identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        if (null == forumParticipantsBeanTempCache) {
            forumParticipantsBeanTempCache = new HashMap<String, ForumParticipantsBean>();
            forumParticipantsBeanTempCacheKeyQueue = new ArrayList<String>();
        }
    }

    @GET
    @Path(value="/clean")
    @RolesAllowed(value={"administrators"})
    public String cleanCache() {
        forumParticipantsBeanTempCache = new HashMap<String, ForumParticipantsBean>();
        forumParticipantsBeanTempCacheKeyQueue = new ArrayList<String>();
        return "done";
    }

    @GET
    @Path(value="/ByPeriod/{filterBy}/{maxResult}")
    @Produces(value={"application/json"})
    public Response getForumParticipantByPeriod(@PathParam(value="filterBy") String filterBy, @PathParam(value="maxResult") String maxResult) {
        if (null == filterBy || filterBy.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.cleanCache();
        int max = 5;
        try {
            max = Integer.parseInt(maxResult);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (max > 20) {
            max = 20;
        }
        try {
            ForumParticipantsBean bean = this.getForumParticipantByPeriod(filterBy, max);
            return Response.ok((Object)bean, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.info((Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Path(value="/ByDate/{fromDateStr}/{toDateStr}/{maxResult}")
    @Produces(value={"application/json"})
    public Response getForumParticipantByDate(@PathParam(value="fromDateStr") String fromDateStr, @PathParam(value="toDateStr") String toDateStr, @PathParam(value="maxResult") String maxResult) {
        this.cleanCache();
        Date fromDate = new Date();
        Date toDate = new Date();
        fromDate = this.parseDate(fromDateStr, "dd-MM-yyyy");
        toDate = this.parseDate(toDateStr, "dd-MM-yyyy");
        if (fromDate == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (toDate == null) {
            toDate = new Date();
        }
        int max = 5;
        try {
            max = Integer.parseInt(maxResult);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (max > 20) {
            max = 20;
        }
        try {
            ForumParticipantsBean bean = this.getForumParticipantsBean(fromDate, toDate, max);
            return Response.ok((Object)bean, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.info((Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    private ForumParticipantsBean getForumParticipantByPeriod(String filterBy, int maxResult) {
        Date fromDate = new Date();
        Date toDate = new Date();
        Calendar fromCal = Calendar.getInstance();
        fromCal.clear();
        fromCal.setTime(toDate);
        fromCal.set(7, fromCal.getFirstDayOfWeek());
        fromDate = fromCal.getTime();
        if (filterBy.equals(FILTER_BY_MONTH)) {
            fromCal.clear();
            fromCal.setTime(toDate);
            fromCal.set(5, 1);
            fromDate = fromCal.getTime();
        }
        if (filterBy.equals(FILTER_BY_YEAR)) {
            fromCal.clear();
            fromCal.setTime(toDate);
            fromCal.set(6, 1);
            fromDate = fromCal.getTime();
        }
        ForumParticipantsBean bean = this.getForumParticipantsBean(fromDate, toDate, maxResult);
        bean.setFilterBy(filterBy);
        return bean;
    }

    private ForumParticipantsBean getForumParticipantsBean(Date fromDate, Date toDate, int maxResult) {
        LOG.info((Object)("getForumParticipant from: " + this.partString(fromDate, "dd-MM-yyyy") + " to: " + this.partString(toDate, "dd-MM-yyyy")));
        StringBuffer key = new StringBuffer();
        key.append(this.partString(fromDate, "dd/MM/yyyy")).append("-").append(this.partString(toDate, "dd/MM/yyyy")).append("-").append(maxResult);
        ForumParticipantsBean bean = forumParticipantsBeanTempCache.get(key.toString());
        if (null == bean) {
            bean = this.buildForumParticipantsBean(fromDate, toDate, maxResult);
            if (forumParticipantsBeanTempCache.size() >= 100) {
                String keyOfFirstObject = forumParticipantsBeanTempCacheKeyQueue.get(0);
                LOG.info((Object)("forumParticipantsBeanTempCache is full, remove first object: " + keyOfFirstObject));
                forumParticipantsBeanTempCache.remove(keyOfFirstObject);
                forumParticipantsBeanTempCacheKeyQueue.remove(0);
            }
            LOG.info((Object)("put " + key.toString() + " to forumParticipantsBeanTempCache"));
            forumParticipantsBeanTempCache.put(key.toString(), bean);
            forumParticipantsBeanTempCacheKeyQueue.add(key.toString());
        }
        return bean;
    }

    private ForumParticipantsBean buildForumParticipantsBean(Date fromDate, Date toDate, int maxResult) {
        LOG.info((Object)"build Data from ForumData");
        ForumParticipantsBean bean = new ForumParticipantsBean();
        bean.setFromDate(fromDate);
        bean.setToDate(toDate);
        bean.setLastUpdate(new Date());
        ArrayList<ForumParticipantProfile> listProfile = new ArrayList<ForumParticipantProfile>();
        Map<String, Long> mapForumParticipants = this.getPostByDate(fromDate, toDate);
        if (null != mapForumParticipants && mapForumParticipants.size() > 0) {
            int index = mapForumParticipants.size() - 1;
            while (index >= 0 && maxResult > 0) {
                try {
                    String userName = mapForumParticipants.keySet().toArray()[index].toString();
                    Long periodPost = mapForumParticipants.get(userName);
                    ForumParticipantProfile forumParticipantProfile = this.buildForumParticipantProfile(userName, periodPost);
                    listProfile.add(forumParticipantProfile);
                    --maxResult;
                    --index;
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
            }
        }
        bean.setListForumParticipantProfile(listProfile);
        return bean;
    }

    private ForumParticipantProfile buildForumParticipantProfile(String userName, Long periodPost) throws Exception {
        ForumParticipantProfile forumParticipantProfile = new ForumParticipantProfile();
        forumParticipantProfile.setUserName(userName);
        UserProfile forumProfile = this.forumService.getUserInfo(userName);
        forumParticipantProfile.setTotalPost(forumProfile.getTotalPost());
        forumParticipantProfile.setPeriodPost(periodPost);
        Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", userName, false);
        Profile userProfile = userIdentity.getProfile();
        forumParticipantProfile.setAvatarUrl(userProfile.getAvatarUrl());
        forumParticipantProfile.setFullName(userProfile.getFullName());
        forumParticipantProfile.setProfileUrl(userProfile.getUrl());
        return forumParticipantProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Long> getPostByDate(Date fromDate, Date toDate) {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        HashMap<String, Long> mapForumParticipant = new HashMap<String, Long>();
        try {
            Map<String, Long> sortMapForumParticipant;
            ManageableRepository currentRepo = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession("knowledge", currentRepo);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String strFromDate = this.getStrFromDate(fromDate);
            String strToDate = this.getStrToDate(toDate);
            StringBuilder sb = new StringBuilder();
            String pathPattern = this.buildPathPattern("/exo:applications/ForumService/ForumData/CategoryHome");
            sb.append("SELECT * FROM exo:post WHERE ");
            if (pathPattern.length() > 0) {
                sb.append(pathPattern).append(" AND ");
            }
            sb.append(" (exo:createdDate >= TIMESTAMP '" + strFromDate + "')").append(" AND ").append(" (exo:createdDate <= TIMESTAMP '" + strToDate + "')");
            QueryImpl query = (QueryImpl)queryManager.createQuery(sb.toString(), "sql");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                String userName = node.getProperty("exo:owner").getString();
                if (mapForumParticipant.get(userName) != null) {
                    Long postCount = (Long)mapForumParticipant.get(userName);
                    mapForumParticipant.put(userName, postCount + 1L);
                    continue;
                }
                mapForumParticipant.put(userName, 1L);
            }
            Map<String, Long> map = sortMapForumParticipant = RestForumParticipant.sortByComparator(mapForumParticipant);
            return map;
        }
        catch (Exception e) {
            LOG.debug((Object)("Error while getting Forum Participants " + e.getMessage()), (Throwable)e);
            Map<String, Long> map = null;
            return map;
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    private static Map<String, Long> sortByComparator(Map<String, Long> unsortMap) {
        LinkedList<Map.Entry<String, Long>> list = new LinkedList<Map.Entry<String, Long>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        LinkedHashMap<String, Long> sortedMap = new LinkedHashMap<String, Long>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (Long)entry.getValue());
        }
        return sortedMap;
    }

    private void printMap(Map<String, Long> map) {
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            LOG.info((Object)("[Key] : " + entry.getKey() + " [Value] : " + entry.getValue()));
        }
    }

    private String getStrFromDate(Date fromDate) {
        Calendar time = Calendar.getInstance();
        time.setTime(fromDate);
        Calendar theFirst = (Calendar)time.clone();
        theFirst.set(time.get(1), time.get(2), time.get(5), 0, 0, 0);
        String theFirstDate = formatDateTime.format(theFirst.getTime());
        return theFirstDate + TIME_FORMAT_TAIL_FROM;
    }

    private String getStrToDate(Date toDate) {
        Calendar time = Calendar.getInstance();
        time.setTime(toDate);
        Calendar theFirst = (Calendar)time.clone();
        theFirst.set(time.get(1), time.get(2), time.get(5), 23, 59, 59);
        String theFirstDate = formatDateTime.format(theFirst.getTime());
        return theFirstDate + TIME_FORMAT_TAIL_TO;
    }

    private String buildPathPattern(String nodePath) {
        if (nodePath.equals("/")) {
            return "";
        }
        return "jcr:path LIKE '" + nodePath + "/%" + "'";
    }

    private Date parseDate(String date, String formatStr) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(formatStr);
            Date ret = format.parse(date);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String partString(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        String s = formatter.format(date);
        return s;
    }

    static {
        formatDateTime.applyPattern("yyyy-MM-dd");
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }

    public class ForumParticipantProfile {
        private String userName;
        private String fullName;
        private String avatarUrl;
        private String profileUrl;
        private long totalPost;
        private long periodPost;

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public void setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
        }

        public long getTotalPost() {
            return this.totalPost;
        }

        public void setTotalPost(long totalPost) {
            this.totalPost = totalPost;
        }

        public long getPeriodPost() {
            return this.periodPost;
        }

        public void setPeriodPost(long periodPost) {
            this.periodPost = periodPost;
        }

        public String getProfileUrl() {
            return this.profileUrl;
        }

        public void setProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
        }
    }

    public class ForumParticipantsBean {
        private Date fromDate;
        private Date toDate;
        private String filterBy;
        private Date lastUpdate;
        List<ForumParticipantProfile> listForumParticipantProfile;

        public Date getFromDate() {
            return this.fromDate;
        }

        public void setFromDate(Date fromDate) {
            this.fromDate = fromDate;
        }

        public Date getToDate() {
            return this.toDate;
        }

        public void setToDate(Date toDate) {
            this.toDate = toDate;
        }

        public String getFilterBy() {
            return this.filterBy;
        }

        public void setFilterBy(String filterBy) {
            this.filterBy = filterBy;
        }

        public Date getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(Date lastUpdate) {
            this.lastUpdate = lastUpdate;
        }

        public List<ForumParticipantProfile> getListForumParticipantProfile() {
            return this.listForumParticipantProfile;
        }

        public void setListForumParticipantProfile(List<ForumParticipantProfile> listForumParticipantProfile) {
            this.listForumParticipantProfile = listForumParticipantProfile;
        }
    }
}

