/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.pulse.listener;

import java.util.Date;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticBean;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

public class LoginCountListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG = ExoLogger.getLogger(LoginCountListener.class);
    private final ActivityStatisticService activityStatsService;

    public LoginCountListener(ActivityStatisticService activityStatsService) throws Exception {
        this.activityStatsService = activityStatsService;
    }

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        String userId = ((ConversationState)event.getData()).getIdentity().getUserId();
        try {
            long now = System.currentTimeMillis();
            ActivityStatisticBean todayStats = this.activityStatsService.getActivityStatisticByDate(new Date(now));
            ActivityStatisticBean objectToUpdate = new ActivityStatisticBean();
            if (null == todayStats) {
                todayStats = this.activityStatsService.startTodayStatistic();
            }
            objectToUpdate.setCreatedDate(todayStats.getCreatedDate());
            objectToUpdate.setModifiedDate(new Date());
            objectToUpdate.setLoginCountToday(todayStats.getLoginCountToday() + 1L);
            this.activityStatsService.createOrUpdate(objectToUpdate);
        }
        catch (Exception e) {
            LOG.debug((Object)("Error while counting the login of user '" + userId + "': " + e.getMessage()), (Throwable)e);
        }
    }
}

