/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.pulse.listener;

import java.util.Date;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticBean;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;

public class SocialRelationshipPublisherListener
extends RelationshipListenerPlugin {
    private ActivityStatisticService activityStatsService;
    private static Log log_ = ExoLogger.getLogger(SocialRelationshipPublisherListener.class);

    public SocialRelationshipPublisherListener(ActivityStatisticService activityStatsService) {
        this.activityStatsService = activityStatsService;
    }

    private void updateActivityStatistic() {
        try {
            long now = System.currentTimeMillis();
            ActivityStatisticBean todayStats = this.activityStatsService.getActivityStatisticByDate(new Date(now));
            ActivityStatisticBean objectToUpdate = new ActivityStatisticBean();
            if (null == todayStats) {
                todayStats = this.activityStatsService.startTodayStatistic();
            }
            objectToUpdate.setCreatedDate(todayStats.getCreatedDate());
            objectToUpdate.setModifiedDate(new Date());
            objectToUpdate.setUserConnectionCountToday(todayStats.getUserConnectionCountToday() + 1L);
            this.activityStatsService.createOrUpdate(objectToUpdate);
        }
        catch (Exception e) {
            log_.error((Object)e);
        }
    }

    public void requested(RelationshipEvent event) {
    }

    public void denied(RelationshipEvent event) {
    }

    public void confirmed(RelationshipEvent event) {
        this.updateActivityStatistic();
    }

    public void ignored(RelationshipEvent event) {
    }

    public void removed(RelationshipEvent event) {
    }
}

