/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.pulse.service.activitystatistic;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticBean;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ActivityStatisticServiceImpl
implements ActivityStatisticService {
    private static final SimpleDateFormat formatDateTime = new SimpleDateFormat();
    private static final String TIME_FORMAT_TAIL_TO = "T23:59:59.999";
    private static final String TIME_FORMAT_TAIL_FROM = "T00:00:00.000";
    private final long DAY_IN_MILLISEC = 86400000L;
    private RepositoryService repositoryService;
    private static final Log LOG = ExoLogger.getLogger(ActivityStatisticServiceImpl.class);

    public ActivityStatisticServiceImpl(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void createHomeNode() throws RepositoryException {
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository currentRepo = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
            Node rootNode = session.getRootNode();
            if (!rootNode.hasNode("exo:activityStatisticHome")) {
                Node homeNode = rootNode.addNode("exo:activityStatisticHome", "exo:activityStatisticHome");
                rootNode.save();
                if (homeNode.canAddMixin("exo:hiddenable")) {
                    homeNode.addMixin("exo:hiddenable");
                }
                LOG.info((Object)"ActivityStatisticHome is initialized.");
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createOrUpdate(ActivityStatisticBean bean) throws Exception {
        Date createdDate = bean.getCreatedDate();
        if (null == createdDate) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createdDate);
        String date = String.valueOf(calendar.get(5));
        String month = String.valueOf(calendar.get(2) + 1);
        String year = String.valueOf(calendar.get(1));
        String nodePath = "exo:activityStatisticHome/" + year + "/" + month + "/" + date;
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository currentRepo = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
            Node rootNode = session.getRootNode();
            if (!rootNode.hasNode(nodePath)) {
                boolean bl = this.createActivityStatistic(bean, year, month, date);
                return bl;
            }
            boolean bl = this.updateActivityStatistic(bean, nodePath);
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createActivityStatistic(ActivityStatisticBean bean, String year, String month, String date) throws Exception {
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository currentRepo = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
            Node rootNode = session.getRootNode();
            Node homeNode = null;
            if (!rootNode.hasNode("exo:activityStatisticHome")) {
                homeNode = rootNode.addNode("exo:activityStatisticHome", "exo:activityStatisticHome");
                rootNode.save();
                if (homeNode.canAddMixin("exo:hiddenable")) {
                    homeNode.addMixin("exo:hiddenable");
                    homeNode.save();
                }
                LOG.info((Object)"ActivityStatisticHome is initialized.");
            } else {
                homeNode = rootNode.getNode("exo:activityStatisticHome");
            }
            Node yearNode = null;
            Node monthNode = null;
            Node dateNode = null;
            if (!homeNode.hasNode(year)) {
                yearNode = homeNode.addNode(year, "exo:activityStatistic");
                homeNode.save();
            } else {
                yearNode = homeNode.getNode(year);
            }
            if (!yearNode.hasNode(month)) {
                monthNode = yearNode.addNode(month, "exo:activityStatistic");
                yearNode.save();
            } else {
                monthNode = yearNode.getNode(month);
            }
            if (!monthNode.hasNode(date)) {
                dateNode = monthNode.addNode(date, "exo:activityStatisticByDay");
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Date());
                dateNode.setProperty("exo:createdDate", cal);
                if (bean.getNewUser() != null && bean.getNewUser() >= 0L) {
                    dateNode.setProperty("exo:newUser", bean.getNewUser().longValue());
                }
                if (bean.getNewUserToday() != null && bean.getNewUserToday() >= 0L) {
                    dateNode.setProperty("exo:newUserToday", bean.getNewUserToday().longValue());
                }
                if (bean.getForumActiveUserToday() != null && bean.getForumActiveUserToday() >= 0L) {
                    dateNode.setProperty("exo:forumActiveUserToday", bean.getForumActiveUserToday().longValue());
                }
                if (bean.getForumPosts() != null && bean.getForumPosts() >= 0L) {
                    dateNode.setProperty("exo:forumPosts", bean.getForumPosts().longValue());
                }
                if (bean.getForumPostToday() != null && bean.getForumPostToday() >= 0L) {
                    dateNode.setProperty("exo:forumPostToday", bean.getForumPostToday().longValue());
                }
                if (bean.getLoginCount() != null && bean.getLoginCount() >= 0L) {
                    dateNode.setProperty("exo:loginCount", bean.getLoginCount().longValue());
                }
                if (bean.getLoginCountToday() != null && bean.getLoginCountToday() >= 0L) {
                    dateNode.setProperty("exo:loginCountToday", bean.getLoginCountToday().longValue());
                }
                if (bean.getUserConnectionCount() != null && bean.getUserConnectionCount() >= 0L) {
                    dateNode.setProperty("exo:userConnectionCount", bean.getUserConnectionCount().longValue());
                }
                if (bean.getUserConnectionCountToday() != null && bean.getUserConnectionCountToday() >= 0L) {
                    dateNode.setProperty("exo:userConnectionCountToday", bean.getUserConnectionCountToday().longValue());
                }
                if (bean.getSocialPostCount() != null && bean.getSocialPostCount() >= 0L) {
                    dateNode.setProperty("exo:socialPostCount", bean.getSocialPostCount().longValue());
                }
                if (bean.getSocialPostCountToday() != null && bean.getSocialPostCountToday() >= 0L) {
                    dateNode.setProperty("exo:socialPostCountToday", bean.getSocialPostCountToday().longValue());
                }
                if (bean.getEmailNotificationCount() != null && bean.getEmailNotificationCount() >= 0L) {
                    dateNode.setProperty("exo:emailNotificationCount", bean.getEmailNotificationCount().longValue());
                }
                if (bean.getEmailNotificationCountToday() != null && bean.getEmailNotificationCountToday() >= 0L) {
                    dateNode.setProperty("exo:emailNotificationToday", bean.getEmailNotificationCountToday().longValue());
                }
                monthNode.save();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateActivityStatistic(ActivityStatisticBean bean, String nodePath) throws Exception {
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository currentRepo = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
            Node rootNode = session.getRootNode();
            Node dateNode = rootNode.getNode(nodePath);
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            dateNode.setProperty("exo:modifiedDate", cal);
            if (bean.getNewUser() != null && bean.getNewUser() >= 0L) {
                dateNode.setProperty("exo:newUser", bean.getNewUser().longValue());
            }
            if (bean.getNewUserToday() != null && bean.getNewUserToday() >= 0L) {
                dateNode.setProperty("exo:newUserToday", bean.getNewUserToday().longValue());
            }
            if (bean.getForumActiveUserToday() != null && bean.getForumActiveUserToday() >= 0L) {
                dateNode.setProperty("exo:forumActiveUserToday", bean.getForumActiveUserToday().longValue());
            }
            if (bean.getForumPosts() != null && bean.getForumPosts() >= 0L) {
                dateNode.setProperty("exo:forumPosts", bean.getForumPosts().longValue());
            }
            if (bean.getForumPostToday() != null && bean.getForumPostToday() >= 0L) {
                dateNode.setProperty("exo:forumPostToday", bean.getForumPostToday().longValue());
            }
            if (bean.getLoginCount() != null && bean.getLoginCount() >= 0L) {
                dateNode.setProperty("exo:loginCount", bean.getLoginCount().longValue());
            }
            if (bean.getLoginCountToday() != null && bean.getLoginCountToday() >= 0L) {
                dateNode.setProperty("exo:loginCountToday", bean.getLoginCountToday().longValue());
            }
            if (bean.getUserConnectionCount() != null && bean.getUserConnectionCount() >= 0L) {
                dateNode.setProperty("exo:userConnectionCount", bean.getUserConnectionCount().longValue());
            }
            if (bean.getUserConnectionCountToday() != null && bean.getUserConnectionCountToday() >= 0L) {
                dateNode.setProperty("exo:userConnectionCountToday", bean.getUserConnectionCountToday().longValue());
            }
            if (bean.getSocialPostCount() != null && bean.getSocialPostCount() >= 0L) {
                dateNode.setProperty("exo:socialPostCount", bean.getSocialPostCount().longValue());
            }
            if (bean.getSocialPostCountToday() != null && bean.getSocialPostCountToday() >= 0L) {
                dateNode.setProperty("exo:socialPostCountToday", bean.getSocialPostCountToday().longValue());
            }
            if (bean.getEmailNotificationCount() != null && bean.getEmailNotificationCount() >= 0L) {
                dateNode.setProperty("exo:emailNotificationCount", bean.getEmailNotificationCount().longValue());
            }
            if (bean.getEmailNotificationCountToday() != null && bean.getEmailNotificationCountToday() >= 0L) {
                dateNode.setProperty("exo:emailNotificationToday", bean.getEmailNotificationCountToday().longValue());
            }
            dateNode.save();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    private Node getActivityStatisticHomeNode(SessionProvider sessionProvider) throws Exception {
        ManageableRepository currentRepo = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
        return session.getRootNode().getNode("exo:activityStatisticHome");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityStatisticBean getActivityStatisticByDate(Date date) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String dateValue = String.valueOf(calendar.get(5));
        String month = String.valueOf(calendar.get(2) + 1);
        String year = String.valueOf(calendar.get(1));
        String nodePath = "exo:activityStatisticHome/" + year + "/" + month + "/" + dateValue;
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository currentRepo = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
            Node rootNode = session.getRootNode();
            if (rootNode.hasNode(nodePath)) {
                Node node = rootNode.getNode(nodePath);
                ActivityStatisticBean activityStatisticBean = this.fillDataToBean(node);
                return activityStatisticBean;
            }
            ActivityStatisticBean activityStatisticBean = null;
            return activityStatisticBean;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            ActivityStatisticBean activityStatisticBean = null;
            return activityStatisticBean;
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityStatisticBean> getListActivityStatisticByDate(Date fromDate, Date toDate) throws Exception {
        ArrayList<ActivityStatisticBean> list = new ArrayList<ActivityStatisticBean>();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            ManageableRepository currentRepo = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String strFromDate = this.getStrFromDate(fromDate);
            String strToDate = this.getStrToDate(toDate);
            StringBuilder sb = new StringBuilder();
            String nodePath = this.getActivityStatisticHomeNode(sessionProvider).getPath();
            String pathPattern = this.buildPathPattern(nodePath);
            sb.append("SELECT * FROM exo:activityStatisticByDay WHERE ");
            if (pathPattern.length() > 0) {
                sb.append(pathPattern).append(" AND ");
            }
            sb.append(" (exo:createdDate >= TIMESTAMP '" + strFromDate + "')").append(" AND ").append(" (exo:createdDate <= TIMESTAMP '" + strToDate + "')");
            QueryImpl query = (QueryImpl)queryManager.createQuery(sb.toString(), "sql");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                ActivityStatisticBean bean = this.fillDataToBean(node);
                list.add(bean);
            }
            ArrayList<ActivityStatisticBean> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            LOG.debug((Object)("Error while getting Activity Statistic " + e.getMessage()), (Throwable)e);
            List<ActivityStatisticBean> list2 = null;
            return list2;
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    private ActivityStatisticBean fillDataToBean(Node node) {
        ActivityStatisticBean bean;
        try {
            bean = new ActivityStatisticBean();
            if (node.hasProperty("exo:createdDate")) {
                bean.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
            }
            if (node.hasProperty("exo:modifiedDate")) {
                bean.setModifiedDate(node.getProperty("exo:modifiedDate").getDate().getTime());
            }
            bean.setNewUser(0L);
            bean.setNewUserToday(0L);
            bean.setForumActiveUserToday(0L);
            bean.setForumPosts(0L);
            bean.setForumPostToday(0L);
            bean.setLoginCount(0L);
            bean.setLoginCountToday(0L);
            bean.setUserConnectionCount(0L);
            bean.setUserConnectionCountToday(0L);
            bean.setSocialPostCount(0L);
            bean.setSocialPostCountToday(0L);
            bean.setEmailNotificationCount(0L);
            bean.setEmailNotificationCountToday(0L);
            if (node.hasProperty("exo:newUser")) {
                bean.setNewUser(node.getProperty("exo:newUser").getLong());
            }
            if (node.hasProperty("exo:newUserToday")) {
                bean.setNewUserToday(node.getProperty("exo:newUserToday").getLong());
            }
            if (node.hasProperty("exo:forumActiveUserToday")) {
                bean.setForumActiveUserToday(node.getProperty("exo:forumActiveUserToday").getLong());
            }
            if (node.hasProperty("exo:forumPosts")) {
                bean.setForumPosts(node.getProperty("exo:forumPosts").getLong());
            }
            if (node.hasProperty("exo:forumPostToday")) {
                bean.setForumPostToday(node.getProperty("exo:forumPostToday").getLong());
            }
            if (node.hasProperty("exo:loginCount")) {
                bean.setLoginCount(node.getProperty("exo:loginCount").getLong());
            }
            if (node.hasProperty("exo:loginCountToday")) {
                bean.setLoginCountToday(node.getProperty("exo:loginCountToday").getLong());
            }
            if (node.hasProperty("exo:userConnectionCount")) {
                bean.setUserConnectionCount(node.getProperty("exo:userConnectionCount").getLong());
            }
            if (node.hasProperty("exo:userConnectionCountToday")) {
                bean.setUserConnectionCountToday(node.getProperty("exo:userConnectionCountToday").getLong());
            }
            if (node.hasProperty("exo:socialPostCount")) {
                bean.setSocialPostCount(node.getProperty("exo:socialPostCount").getLong());
            }
            if (node.hasProperty("exo:socialPostCountToday")) {
                bean.setSocialPostCountToday(node.getProperty("exo:socialPostCountToday").getLong());
            }
            if (node.hasProperty("exo:emailNotificationCount")) {
                bean.setEmailNotificationCount(node.getProperty("exo:emailNotificationCount").getLong());
            }
            if (node.hasProperty("exo:emailNotificationToday")) {
                bean.setEmailNotificationCountToday(node.getProperty("exo:emailNotificationToday").getLong());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
        return bean;
    }

    private String getStrFromDate(Date fromDate) {
        Calendar time = Calendar.getInstance();
        time.setTime(fromDate);
        Calendar theFirst = (Calendar)time.clone();
        theFirst.set(time.get(1), time.get(2), time.get(5), 0, 0, 0);
        String theFirstDate = formatDateTime.format(theFirst.getTime());
        return theFirstDate + TIME_FORMAT_TAIL_FROM;
    }

    private String getStrToDate(Date toDate) {
        Calendar time = Calendar.getInstance();
        time.setTime(toDate);
        Calendar theFirst = (Calendar)time.clone();
        theFirst.set(time.get(1), time.get(2), time.get(5), 23, 59, 59);
        String theFirstDate = formatDateTime.format(theFirst.getTime());
        return theFirstDate + TIME_FORMAT_TAIL_TO;
    }

    private String buildPathPattern(String nodePath) {
        if (nodePath.equals("/")) {
            return "";
        }
        return "jcr:path LIKE '" + nodePath + "/%" + "'";
    }

    @Override
    public ActivityStatisticBean startTodayStatistic() throws Exception {
        ActivityStatisticBean todayStats = new ActivityStatisticBean();
        try {
            long now = System.currentTimeMillis();
            ActivityStatisticBean yesterdayStats = this.getActivityStatisticByDate(new Date(now - 86400000L));
            if (null != yesterdayStats) {
                todayStats.setCreatedDate(new Date(now));
                todayStats.setLoginCount(yesterdayStats.getLoginCount() + yesterdayStats.getLoginCountToday());
                todayStats.setLoginCountToday(0L);
                todayStats.setForumPosts(yesterdayStats.getForumPosts() + yesterdayStats.getForumPostToday());
                todayStats.setForumPostToday(0L);
                todayStats.setNewUser(yesterdayStats.getNewUser() + yesterdayStats.getNewUserToday());
                todayStats.setNewUserToday(0L);
                todayStats.setForumActiveUserToday(0L);
                todayStats.setUserConnectionCount(yesterdayStats.getUserConnectionCount() + yesterdayStats.getUserConnectionCountToday());
                todayStats.setUserConnectionCountToday(0L);
                todayStats.setSocialPostCount(yesterdayStats.getSocialPostCount() + yesterdayStats.getSocialPostCountToday());
                todayStats.setSocialPostCountToday(0L);
                todayStats.setEmailNotificationCount(yesterdayStats.getEmailNotificationCount() + yesterdayStats.getEmailNotificationCountToday());
                todayStats.setEmailNotificationCountToday(0L);
            } else {
                todayStats.setCreatedDate(new Date(now));
                todayStats.setLoginCount(0L);
                todayStats.setLoginCountToday(0L);
                ForumService forumService = (ForumService)CommonUtils.getComponent(ForumService.class);
                if (null != forumService) {
                    todayStats.setForumPosts(forumService.getForumStatistic().getPostCount());
                } else {
                    todayStats.setForumPosts(0L);
                }
                todayStats.setForumPostToday(0L);
                todayStats.setNewUser(0L);
                todayStats.setNewUserToday(0L);
                todayStats.setForumActiveUserToday(0L);
                todayStats.setUserConnectionCountToday(0L);
                todayStats.setSocialPostCountToday(0L);
                todayStats.setEmailNotificationCountToday(0L);
            }
            this.createOrUpdate(todayStats);
        }
        catch (Exception e) {
            LOG.debug((Object)("Can not start Activity Statistic for today " + e.getMessage()), (Throwable)e);
            return null;
        }
        return todayStats;
    }

    @Override
    public boolean upgrade() throws Exception {
        try {
            this.registerNodeTypes("war:/conf/community-forums-extension/nodetypes/nodetype-activity-statistic.xml", 4);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void registerNodeTypes(String nodeTypeFilesName, int alreadyExistsBehaviour) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ConfigurationManager configurationService = (ConfigurationManager)container.getComponentInstanceOfType(ConfigurationManager.class);
        InputStream isXml = configurationService.getInputStream(nodeTypeFilesName);
        ExtendedNodeTypeManager ntManager = this.repositoryService.getCurrentRepository().getNodeTypeManager();
        LOG.info((Object)("\nTrying register node types from xml-file " + nodeTypeFilesName));
        ntManager.registerNodeTypes(isXml, alreadyExistsBehaviour, "text/xml");
        LOG.info((Object)("\nNode types were registered from xml-file " + nodeTypeFilesName));
    }

    static {
        formatDateTime.applyPattern("yyyy-MM-dd");
    }
}

