/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.pulse.listener;

import java.util.Date;
import java.util.List;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticBean;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticService;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumEventListener;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PlatformForumEventListener
extends ForumEventListener {
    private ActivityStatisticService activityStatsService;
    private ForumService forumService;
    private static Log log_ = ExoLogger.getLogger(PlatformForumEventListener.class);
    private final long DAY_IN_MILLISEC = 86400000L;

    public PlatformForumEventListener(ActivityStatisticService activityStatsService, ForumService forumService) {
        this.activityStatsService = activityStatsService;
        this.forumService = forumService;
    }

    private void updateActivityStatistic() {
        block5: {
            try {
                if (this.forumService != null && this.activityStatsService != null) {
                    long now = System.currentTimeMillis();
                    ForumStatistic forumStats = this.forumService.getForumStatistic();
                    ActivityStatisticBean todayStats = this.activityStatsService.getActivityStatisticByDate(new Date(now));
                    ActivityStatisticBean objectToUpdate = new ActivityStatisticBean();
                    if (null == todayStats) {
                        todayStats = this.activityStatsService.startTodayStatistic();
                        todayStats.setForumPosts(forumStats.getPostCount());
                    }
                    objectToUpdate.setCreatedDate(todayStats.getCreatedDate());
                    objectToUpdate.setModifiedDate(new Date());
                    objectToUpdate.setForumPostToday(forumStats.getPostCount() - todayStats.getForumPosts());
                    ActivityStatisticBean yesterdayStats = this.activityStatsService.getActivityStatisticByDate(new Date(now - 86400000L));
                    long yestPost = todayStats.getForumPosts();
                    if (null != yesterdayStats) {
                        yestPost = yesterdayStats.getForumPosts() + yesterdayStats.getForumPostToday();
                    }
                    objectToUpdate.setForumPosts(yestPost);
                    objectToUpdate.setForumActiveUserToday(forumStats.getActiveUsers());
                    this.activityStatsService.createOrUpdate(objectToUpdate);
                }
            }
            catch (Exception e) {
                if (!log_.isDebugEnabled()) break block5;
                log_.debug((Object)("Can not update Activity Statustic: " + e.getMessage()));
            }
        }
    }

    public void addTopic(Topic topic) {
        this.updateActivityStatistic();
    }

    public void updateTopic(Topic topic) {
    }

    public void updateTopics(List<Topic> topics, boolean isLock) {
    }

    public void moveTopic(Topic topic, String toCategoryName, String toForumName) {
    }

    public void mergeTopic(Topic newTopic, String removeActivityId1, String removeActivityId2) {
        this.updateActivityStatistic();
    }

    public void splitTopic(Topic newTopic, Topic splitedTopic, String removeActivityId) {
        this.updateActivityStatistic();
    }

    public void addPost(Post post) {
        this.updateActivityStatistic();
    }

    public void updatePost(Post post) {
    }

    public void updatePost(Post post, int type) {
    }

    public void removeActivity(String activityId) {
        this.updateActivityStatistic();
    }

    public void removeComment(String activityId, String commentId) {
        this.updateActivityStatistic();
    }

    public void saveCategory(Category category) {
        this.updateActivityStatistic();
    }

    public void saveForum(Forum forum) {
        this.updateActivityStatistic();
    }

    public void movePost(List<Post> posts, List<String> srcPostActivityIds, String desTopicPath) {
    }
}

