/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.pulse.listener;

import java.util.Date;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticBean;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class PlatformUserEventListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(PlatformUserEventListener.class);
    private final ActivityStatisticService activityStatsService;
    private final long DAY_IN_MILLISEC = 86400000L;

    public PlatformUserEventListener(ActivityStatisticService activityStatsService) {
        this.activityStatsService = activityStatsService;
    }

    public void preSave(User user, boolean isNew) throws Exception {
        super.preSave(user, isNew);
    }

    public void postSave(User user, boolean isNew) throws Exception {
        try {
            if (isNew) {
                long now = System.currentTimeMillis();
                ActivityStatisticBean todayStats = this.activityStatsService.getActivityStatisticByDate(new Date(now));
                ActivityStatisticBean objectToUpdate = new ActivityStatisticBean();
                if (null == todayStats) {
                    todayStats = this.activityStatsService.startTodayStatistic();
                }
                objectToUpdate.setCreatedDate(todayStats.getCreatedDate());
                objectToUpdate.setModifiedDate(new Date());
                objectToUpdate.setNewUserToday(todayStats.getNewUserToday() + 1L);
                this.activityStatsService.createOrUpdate(objectToUpdate);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Error while counting the new registration: " + e.getMessage()), (Throwable)e);
        }
        super.postSave(user, isNew);
    }

    public void preDelete(User user) throws Exception {
        super.preDelete(user);
    }

    public void postDelete(User user) throws Exception {
        super.postDelete(user);
    }
}

