/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.pulse.service.activitystatistic;

import java.util.Date;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticBean;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticService;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.job.MultiTenancyJob;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.JobExecutionContext;

public class ForumStatisticCounterJob
extends MultiTenancyJob {
    private static Log log_ = ExoLogger.getLogger((String)"job.forum.RecountActiveUserJob");
    private final long DAY_IN_MILLISEC = 86400000L;

    public Class<? extends MultiTenancyJob.MultiTenancyTask> getTask() {
        return ForumCounterTask.class;
    }

    public class ForumCounterTask
    extends MultiTenancyJob.MultiTenancyTask {
        public ForumCounterTask(JobExecutionContext context, String repoName) {
            super((MultiTenancyJob)ForumStatisticCounterJob.this, context, repoName);
        }

        public void run() {
            block5: {
                super.run();
                try {
                    ForumService forumService = (ForumService)this.container.getComponentInstanceOfType(ForumService.class);
                    ActivityStatisticService activityStatsService = (ActivityStatisticService)this.container.getComponentInstanceOfType(ActivityStatisticService.class);
                    if (forumService != null && activityStatsService != null) {
                        long now = System.currentTimeMillis();
                        ForumStatistic forumStats = forumService.getForumStatistic();
                        ActivityStatisticBean todayStats = activityStatsService.getActivityStatisticByDate(new Date(now));
                        ActivityStatisticBean objectToUpdate = new ActivityStatisticBean();
                        if (null == todayStats) {
                            todayStats = activityStatsService.startTodayStatistic();
                            todayStats.setForumPosts(forumStats.getPostCount());
                        }
                        objectToUpdate.setCreatedDate(todayStats.getCreatedDate());
                        objectToUpdate.setModifiedDate(new Date());
                        objectToUpdate.setForumPostToday(forumStats.getPostCount() - todayStats.getForumPosts());
                        ActivityStatisticBean yesterdayStats = activityStatsService.getActivityStatisticByDate(new Date(now - 86400000L));
                        long yestPost = todayStats.getForumPosts();
                        if (null != yesterdayStats) {
                            yestPost = yesterdayStats.getForumPosts() + yesterdayStats.getForumPostToday();
                        }
                        objectToUpdate.setForumPosts(yestPost);
                        objectToUpdate.setForumActiveUserToday(forumStats.getActiveUsers());
                        activityStatsService.createOrUpdate(objectToUpdate);
                    }
                }
                catch (Exception e) {
                    if (!log_.isDebugEnabled()) break block5;
                    log_.debug((Object)("Can not update Activity Statustic: " + e.getMessage()));
                }
            }
        }
    }
}

