/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.push.domain.Device;
import org.exoplatform.push.service.DeviceService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/v1/messaging/device")
@Api(tags={"/v1/messaging/device"}, value="/v1/messaging/device", description="Managing devices for Push Notifications")
public class DeviceRestService
implements ResourceContainer {
    private DeviceService deviceService;
    private UserACL userACL;

    public DeviceRestService(DeviceService deviceService, UserACL userACL) {
        this.deviceService = deviceService;
        this.userACL = userACL;
    }

    @GET
    @Path(value="{token}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a device by token", httpMethod="GET", response=Response.class, notes="This returns the device in the following cases: <br/><ul><li>the owner of the device is the authenticated user</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Device returned"), @ApiResponse(code=400, message="Invalid query input - token is not valid"), @ApiResponse(code=401, message="Not authorized to get the device linked to the token"), @ApiResponse(code=500, message="Internal server error")})
    public Response getDevice(@ApiParam(value="Token", required=true) @PathParam(value="token") String token) {
        if (StringUtils.isBlank((String)token)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Device device = this.deviceService.getDeviceByToken(token);
        if (device == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String authenticatedUser = conversationState.getIdentity().getUserId();
        if (StringUtils.isEmpty((String)authenticatedUser) || !authenticatedUser.equals(device.getUsername()) && !authenticatedUser.equals(this.userACL.getSuperUser())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return Response.ok((Object)device).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Creates a device", httpMethod="POST", response=Response.class, notes="This creates the device in the following cases: <br/><ul><li>the owner of the device is the authenticated user</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Device created"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Not authorized to create the device"), @ApiResponse(code=500, message="Internal server error")})
    public Response createDevice(@ApiParam(value="Device", required=true) Device device) {
        if (device == null || StringUtils.isBlank((String)device.getToken()) || StringUtils.isBlank((String)device.getUsername())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = conversationState.getIdentity().getUserId();
        if (StringUtils.isEmpty((String)authenticatedUser) || !authenticatedUser.equals(device.getUsername()) && !authenticatedUser.equals(this.userACL.getSuperUser())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.deviceService.createDevice(device);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{token}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a device", httpMethod="DELETE", response=Response.class, notes="This deletes the device in the following cases: <br/><ul><li>the owner of the device is the authenticated user</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Device deleted"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Not authorized to delete the device"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteDevice(@ApiParam(value="Token", required=true) @PathParam(value="token") String token) {
        if (StringUtils.isBlank((String)token)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Device device = this.deviceService.getDeviceByToken(token);
        if (device == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String authenticatedUser = conversationState.getIdentity().getUserId();
        if (StringUtils.isEmpty((String)authenticatedUser) || !authenticatedUser.equals(device.getUsername()) && !authenticatedUser.equals(this.userACL.getSuperUser())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.deviceService.deleteDevice(device);
        return Response.ok().build();
    }
}

