/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.service;

import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.push.dao.DeviceDao;
import org.exoplatform.push.domain.Device;
import org.exoplatform.push.service.DeviceService;
import org.exoplatform.push.service.DeviceServiceImpl$AjcClosure1;
import org.exoplatform.push.service.DeviceServiceImpl$AjcClosure3;
import org.exoplatform.push.service.DeviceServiceImpl$AjcClosure5;
import org.exoplatform.push.util.StringUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DeviceServiceImpl
implements DeviceService {
    private static final Log LOG;
    private DeviceDao deviceDao;
    private int tokenExpirationSeconds = 5184000;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public DeviceServiceImpl(InitParams initParams, DeviceDao deviceDao) {
        ValueParam tokenExpirationTimeParam;
        if (initParams != null && (tokenExpirationTimeParam = initParams.getValueParam("tokenExpirationTime")) != null) {
            try {
                this.tokenExpirationSeconds = Integer.parseInt(tokenExpirationTimeParam.getValue());
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Push Notifications - Token expiration time is not a valid number (" + tokenExpirationTimeParam.getValue() + "), using default value " + this.tokenExpirationSeconds), (Throwable)e);
            }
        }
        this.deviceDao = deviceDao;
    }

    @Override
    public void createDevice(Device device) {
        if (device.getRegistrationDate() == null) {
            device.setRegistrationDate(new Date());
        }
        this.deviceDao.create(device);
        LOG.info("New device registered : username={}, token={}, type={}", new Object[]{device.getUsername(), StringUtil.mask(device.getToken(), 4), device.getType()});
    }

    @Override
    public void deleteDevice(Device device) {
        this.deviceDao.delete(device);
        LOG.info("Device unregistered : username={}, token={}, type={}", new Object[]{device.getUsername(), StringUtil.mask(device.getToken(), 4), device.getType()});
    }

    @Override
    public Device getDeviceById(Long deviceId) {
        return (Device)this.deviceDao.find(deviceId);
    }

    @Override
    @ExoTransactional
    public List<Device> getDevicesByUser(String username) {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new DeviceServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Device getDeviceByToken(String token) {
        String string = token;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Device)ExoTransactionalAspect.aspectOf().around(new DeviceServiceImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void deleteDevicesWithExpiredToken() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new DeviceServiceImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    static {
        DeviceServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(DeviceServiceImpl.class);
    }

    static /* synthetic */ List getDevicesByUser_aroundBody0(DeviceServiceImpl ajc$this, String username, JoinPoint joinPoint) {
        return ajc$this.deviceDao.findByUsername(username);
    }

    static /* synthetic */ Device getDeviceByToken_aroundBody2(DeviceServiceImpl ajc$this, String token, JoinPoint joinPoint) {
        return ajc$this.deviceDao.findByToken(token);
    }

    static /* synthetic */ void deleteDevicesWithExpiredToken_aroundBody4(DeviceServiceImpl ajc$this, JoinPoint joinPoint) {
        long expirationTimeMillis = ajc$this.tokenExpirationSeconds * 1000;
        Instant instant = Instant.now();
        long currentTimeStamp = instant.toEpochMilli();
        Instant expirationInstant = Instant.ofEpochMilli(currentTimeStamp - expirationTimeMillis);
        int nbDeleted = ajc$this.deviceDao.deleteDevicesWithTokenOlderThan(Date.from(expirationInstant));
        LOG.debug("{} devices deleted", new Object[]{nbDeleted});
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeviceServiceImpl.java", DeviceServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDevicesByUser", "org.exoplatform.push.service.DeviceServiceImpl", "java.lang.String", "username", "", "java.util.List"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDeviceByToken", "org.exoplatform.push.service.DeviceServiceImpl", "java.lang.String", "token", "", "org.exoplatform.push.domain.Device"), 65);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteDevicesWithExpiredToken", "org.exoplatform.push.service.DeviceServiceImpl", "", "", "", "void"), 70);
    }
}

