/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.push.domain.Device;
import org.exoplatform.push.service.DeviceService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/v1/messaging/device")
@Tag(name="/v1/messaging/device", description="Managing devices for Push Notifications")
public class DeviceRestService
implements ResourceContainer {
    private DeviceService deviceService;
    private UserACL userACL;

    public DeviceRestService(DeviceService deviceService, UserACL userACL) {
        this.deviceService = deviceService;
        this.userACL = userACL;
    }

    @GET
    @Path(value="{token}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a device by token", method="GET", description="This returns the device in the following cases: <br/><ul><li>the owner of the device is the authenticated user</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Device returned"), @ApiResponse(responseCode="400", description="Invalid query input - token is not valid"), @ApiResponse(responseCode="401", description="Not authorized to get the device linked to the token"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getDevice(@Parameter(description="Token", required=true) @PathParam(value="token") String token) {
        if (StringUtils.isBlank((String)token)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Device device = this.deviceService.getDeviceByToken(token);
        if (device == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String authenticatedUser = conversationState.getIdentity().getUserId();
        if (StringUtils.isEmpty((String)authenticatedUser) || !authenticatedUser.equals(device.getUsername()) && !authenticatedUser.equals(this.userACL.getSuperUser())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return Response.ok((Object)device, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates or updates a device", method="POST", description="This creates or updates the device in the following cases: <br/><ul><li>the owner of the device is the authenticated user</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Device created"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Not authorized to create the device"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveDevice(@Parameter(description="Device", required=true) Device device) {
        if (device == null || StringUtils.isBlank((String)device.getToken()) || StringUtils.isBlank((String)device.getUsername())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = conversationState.getIdentity().getUserId();
        if (StringUtils.isEmpty((String)authenticatedUser) || !authenticatedUser.equals(device.getUsername()) && !authenticatedUser.equals(this.userACL.getSuperUser())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.deviceService.saveDevice(device);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{token}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes a device", method="DELETE", description="This deletes the device in the following cases: <br/><ul><li>the owner of the device is the authenticated user</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Device deleted"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Not authorized to delete the device"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteDevice(@Parameter(description="Token", required=true) @PathParam(value="token") String token) {
        if (StringUtils.isBlank((String)token)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Device device = this.deviceService.getDeviceByToken(token);
        if (device == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String authenticatedUser = conversationState.getIdentity().getUserId();
        if (StringUtils.isEmpty((String)authenticatedUser) || !authenticatedUser.equals(device.getUsername()) && !authenticatedUser.equals(this.userACL.getSuperUser())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.deviceService.deleteDevice(device);
        return Response.ok().build();
    }
}

