/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.removemyaccount.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.web.filter.Filter;

public class RemoveMyAccountProfileFilter
implements Filter {
    private static final Log log = ExoLogger.getLogger(RemoveMyAccountProfileFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String currentUser = req.getRemoteUser();
        if (null != currentUser) {
            try {
                UserHandler userHandler;
                String reqURI = req.getRequestURI();
                String[] paths = reqURI.split("/");
                String usernameVisivited = paths[paths.length - 1];
                if (!currentUser.equals(usernameVisivited) && null == (userHandler = ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler()).findUserByName(usernameVisivited)) {
                    log.info((Object)(" webui remove filter cannot find user for " + usernameVisivited));
                    res.sendRedirect("/portal/intranet/profile");
                    return;
                }
            }
            catch (Exception e) {
                log.error((Object)("ERR remove account webui filter " + e.getMessage()));
            }
        }
        chain.doFilter(request, response);
    }
}

