/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.removemyaccount.commons.services;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.json.JSONObject;
import org.juzu.removemyaccount.commons.models.Account;
import org.juzu.removemyaccount.commons.services.RemoveMyAccountService;

@Singleton
public class RemoveMyAccountJCRImpl
implements RemoveMyAccountService {
    private static final Log log = ExoLogger.getLogger(RemoveMyAccountJCRImpl.class);
    private static final String REMOVE_ACCOUNT_APP = "RemoveAccountApplication";
    private static final String NODE_PROPS_USERNAME = "exo:username";
    private static final String NODE_PROPS_REASON = "exo:reason";
    private static final String NODE_PROPS_UNSUBSCRIBE_MKT_EMAIL = "exo:unsubscribe-marketing-email";
    @Inject
    SessionProviderService sessionProviderService;
    @Inject
    NodeHierarchyCreator nodeHierarchyCreator;
    @Inject
    OrganizationService organizationService;

    private Node getOrCreateRemoveAccountAppHome() throws Exception {
        Node removeAccApp = null;
        SessionProvider sProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Node publicApp = this.nodeHierarchyCreator.getPublicApplicationNode(sProvider);
        try {
            if (publicApp.hasNode(REMOVE_ACCOUNT_APP)) {
                removeAccApp = publicApp.getNode(REMOVE_ACCOUNT_APP);
            } else {
                removeAccApp = publicApp.addNode(REMOVE_ACCOUNT_APP, "nt:unstructured");
                publicApp.getSession().save();
            }
        }
        catch (Exception e) {
            log.error((Object)"ERR Remove Account App cannot get home folder");
        }
        return removeAccApp;
    }

    private void setNodeProperties(Node aNode, Account account) throws RepositoryException {
        aNode.setProperty(NODE_PROPS_USERNAME, account.getUsername());
        aNode.setProperty(NODE_PROPS_REASON, account.getReason());
        aNode.setProperty(NODE_PROPS_UNSUBSCRIBE_MKT_EMAIL, account.getUnsubscibeMarketingEmail().booleanValue());
    }

    private Account transferNode2Account(Node node) throws RepositoryException {
        if (null == node) {
            return null;
        }
        Account account = new Account("");
        PropertyIterator iter = node.getProperties("exo:*");
        while (iter.hasNext()) {
            Property p = iter.nextProperty();
            String name = p.getName();
            if (name.equals(NODE_PROPS_USERNAME)) {
                account.setUsername(p.getString());
                continue;
            }
            if (name.equals(NODE_PROPS_REASON)) {
                account.setReason(p.getString());
                continue;
            }
            if (!name.equals(NODE_PROPS_UNSUBSCRIBE_MKT_EMAIL)) continue;
            account.setUnsubscibeMarketingEmail(Boolean.valueOf(p.getBoolean()));
        }
        if (account.checkValid()) {
            return account;
        }
        return null;
    }

    public Account storeAccount(Account account) {
        Node homeApp = null;
        try {
            homeApp = this.getOrCreateRemoveAccountAppHome();
            Node accountNode = null;
            if (null != homeApp) {
                if (homeApp.hasNode(account.getUsername())) {
                    accountNode = homeApp.getNode(account.getUsername());
                } else {
                    accountNode = homeApp.addNode(account.getUsername());
                    this.setNodeProperties(accountNode, account);
                    homeApp.save();
                }
            }
            if (null != accountNode) {
                if (null != this.organizationService.getUserHandler().removeUser(account.getUsername(), false)) {
                    return this.transferNode2Account(accountNode);
                }
                log.error((Object)"ERR remove account => cannot remove user");
            }
        }
        catch (Exception e) {
            log.error((Object)"ERR remove account cannot store remove account info ");
            e.getMessage();
        }
        return null;
    }

    public JSONObject getInfoUser(String username) {
        JSONObject info = null;
        try {
            User user = this.organizationService.getUserHandler().findUserByName(username);
            if (null != user) {
                info = new JSONObject();
                info.put("username", (Object)username);
                info.put("email", (Object)user.getEmail());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }
}

