/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.removemyaccount.portlet.frontend;

import javax.inject.Inject;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.ajax.Ajax;
import juzu.request.SecurityContext;
import org.json.JSONException;
import org.json.JSONObject;
import org.juzu.removemyaccount.commons.models.Account;
import org.juzu.removemyaccount.commons.models.Reason;
import org.juzu.removemyaccount.commons.services.RemoveMyAccountService;
import org.juzu.removemyaccount.portlet.frontend.templates.index;

public class JuZFrontendApplication {
    @Inject
    RemoveMyAccountService removeMyAccountService;
    @Inject
    @Path(value="index.gtmpl")
    index indexTpl;

    @View
    public Response.Content index(SecurityContext securityContext) {
        String currentUserName = securityContext.getUserPrincipal().getName();
        JSONObject info = this.removeMyAccountService.getInfoUser(currentUserName);
        if (null != info) {
            try {
                return this.indexTpl.with().set("email", info.get("email")).set("reasons", (Object)Reason.values()).set("username", (Object)currentUserName).ok();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return Response.ok((CharSequence)"something went wrong, cannot get user info");
    }

    @Ajax
    @Resource
    public Response doRemoveMyAccount(SecurityContext securityContext, String reason, String unSubscribeMktEmail) {
        String reasonContent = "";
        try {
            reasonContent = Reason.getReason((int)Integer.parseInt(reason)).getContent();
        }
        catch (NumberFormatException e) {
            reasonContent = reason;
        }
        String currentUserName = securityContext.getUserPrincipal().getName();
        Account account = new Account(currentUserName);
        account.setReason(reasonContent);
        if (unSubscribeMktEmail.equals("1")) {
            account.setUnsubscibeMarketingEmail(Boolean.valueOf(true));
        }
        if (account.checkValid()) {
            if (null != this.removeMyAccountService.storeAccount(account)) {
                // empty if block
            }
            return Response.ok((CharSequence)"http://");
        }
        return Response.ok((CharSequence)"nok");
    }
}

