/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.dao;

import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.rhmanagement.entity.BalanceHistoryEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceHistoryDAO
extends GenericDAOJPAImpl<BalanceHistoryEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(BalanceHistoryDAO.class);

    public List<BalanceHistoryEntity> getBalanceHistoryByUserId(String id, long fromDate, long toDate, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("balanceHistoryEntity.findByUserId", BalanceHistoryEntity.class).setParameter("userId", (Object)id).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("balanceHistoryEntity.findByUserId", BalanceHistoryEntity.class).setParameter("userId", (Object)id).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get history with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<BalanceHistoryEntity> getBalanceHistoryByDate(long fromDate, long toDate, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("balanceHistoryEntity.findByDate", BalanceHistoryEntity.class).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("balanceHistoryEntity.findByDate", BalanceHistoryEntity.class).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get history with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public long getBalanceHistoryByUserIdCount(String id) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("balanceHistoryEntity.count", Long.class).setParameter("userId", (Object)id).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get history count.", (Throwable)e);
            throw e;
        }
    }
}

