/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.rhmanagement.dao.ConventionalVacationDAO;
import org.exoplatform.rhmanagement.dto.ConventionalVacationDTO;
import org.exoplatform.rhmanagement.entity.ConventionalVacationEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConventionalVacationService {
    private final Logger LOG = LoggerFactory.getLogger(ConventionalVacationService.class);
    private ConventionalVacationDAO conventionalVacationDAO = new ConventionalVacationDAO();

    public ConventionalVacationDTO save(ConventionalVacationDTO entity, boolean newCv) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' is null");
        }
        ConventionalVacationEntity conventionalVacationEntity = null;
        conventionalVacationEntity = newCv ? (ConventionalVacationEntity)this.conventionalVacationDAO.create(this.convert(entity)) : (ConventionalVacationEntity)this.conventionalVacationDAO.update(this.convert(entity));
        return this.convert(conventionalVacationEntity);
    }

    public void remove(ConventionalVacationDTO entity) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' = + " + entity + " or 'entity.id' is null");
        }
        this.conventionalVacationDAO.delete(this.convert(entity));
    }

    public List<ConventionalVacationDTO> getConventionalVacations(int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getCommentsByRequestID - Parameter 'offset' must be positive");
        }
        List<ConventionalVacationEntity> entities = this.conventionalVacationDAO.getConventionalVacations(offset, limit);
        ArrayList<ConventionalVacationDTO> dtos = new ArrayList<ConventionalVacationDTO>();
        for (ConventionalVacationEntity entity : entities) {
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public long getConventionalVacationsCount() {
        return this.conventionalVacationDAO.getConventionalVacationsCount();
    }

    public ConventionalVacationDTO getConventionalVacationsById(long id) {
        return this.convert(this.conventionalVacationDAO.getConventionalVacationById(id));
    }

    private ConventionalVacationEntity convert(ConventionalVacationDTO dto) {
        ConventionalVacationEntity entity = new ConventionalVacationEntity();
        entity.setId(dto.getId());
        entity.setLabel(dto.getLabel());
        entity.setDaysNumber(dto.getDaysNumber());
        entity.setDescription(dto.getDescription());
        entity.setWorkingDays(dto.getWorkingDays());
        return entity;
    }

    private ConventionalVacationDTO convert(ConventionalVacationEntity entity) {
        ConventionalVacationDTO dto = new ConventionalVacationDTO();
        dto.setId(entity.getId());
        dto.setLabel(entity.getLabel());
        dto.setDaysNumber(entity.getDaysNumber());
        dto.setDescription(entity.getDescription());
        dto.setWorkingDays(entity.getWorkingDays());
        return dto;
    }
}

