/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.dao;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.rhmanagement.entity.VacationRequestEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VacationRequestDAO
extends GenericDAOJPAImpl<VacationRequestEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(VacationRequestDAO.class);

    public List<VacationRequestEntity> getVacationRequests(int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findAllOrderBy", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.findAll();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public long getVacationRequestesCount() {
        try {
            return (Long)this.getEntityManager().createNamedQuery("vacatioRequestEntity.count", Long.class).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests count.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getActiveVacationRequests(int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findActive", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("currentDate", (Object)new Date(System.currentTimeMillis() - 86400000L)).getResultList();
            }
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findActive", VacationRequestEntity.class).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getWaitingVacationRequests(int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findWaiting", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findWaiting", VacationRequestEntity.class).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public long getActiveVacationRequestsCount() {
        try {
            return (Long)this.getEntityManager().createNamedQuery("vacatioRequestEntity.countActive", Long.class).setParameter("currentDate", (Object)new Date(System.currentTimeMillis() - 86400000L)).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests count.", (Throwable)e);
            throw e;
        }
    }

    public long getWaitingVacationRequestsCount() {
        try {
            return (Long)this.getEntityManager().createNamedQuery("vacatioRequestEntity.countWaiting", Long.class).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests count.", (Throwable)e);
            throw e;
        }
    }

    public long getVacationRequestsByTypeCount(String type) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("vacatioRequestEntity.countByType", Long.class).setParameter("type", (Object)type).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests count.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getVacationRequestsByUserId(String userId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByUserId", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("userId", (Object)userId).getResultList();
            }
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByUserId", VacationRequestEntity.class).setParameter("userId", (Object)userId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getVacationRequestsByType(String type, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByType", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("type", (Object)type).getResultList();
            }
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByType", VacationRequestEntity.class).setParameter("type", (Object)type).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getVacationRequestsByUserIdAndStatus(String userId, String status, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByUserIdAndStatus", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("userId", (Object)userId).setParameter("status", (Object)status).getResultList();
            }
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByUserIdAndStatus", VacationRequestEntity.class).setParameter("userId", (Object)userId).setParameter("status", (Object)status).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getActiveVacationRequestsByUserId(String userId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findActiveByUserId", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("userId", (Object)userId).setParameter("currentDate", (Object)new Date(System.currentTimeMillis() - 86400000L)).getResultList();
            }
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findActiveByUserId", VacationRequestEntity.class).setParameter("userId", (Object)userId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getVacationRequestsByValidator(String userId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByValidator", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("userId", (Object)userId).getResultList();
            }
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByValidator", VacationRequestEntity.class).setParameter("userId", (Object)userId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getActiveVacationRequestsByValidator(String userId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findActiveByValidator", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("userId", (Object)userId).setParameter("currentDate", (Object)new Date(System.currentTimeMillis() - 86400000L)).getResultList();
            }
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findActiveByValidator", VacationRequestEntity.class).setParameter("userId", (Object)userId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getVacationRequestsByValidatorAndStatus(String userId, String status, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByValidatorAndStatus", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("userId", (Object)userId).setParameter("status", (Object)status).getResultList();
            }
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByValidatorAndStatus", VacationRequestEntity.class).setParameter("userId", (Object)userId).setParameter("status", (Object)status).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getVacationRequestbyId(long id) {
        try {
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findById", VacationRequestEntity.class).setParameter("id", (Object)id).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getVacationRequestsbyDate(Date date) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, 0);
            Date minDate = cal.getTime();
            cal.setTime(date);
            cal.set(11, 23);
            Date maxDate = cal.getTime();
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByDate", VacationRequestEntity.class).setParameter("minDate", (Object)minDate).setParameter("maxDate", (Object)maxDate).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getActiveVacationRequestsByManager(String managerId, List<String> listSubs, int offset, int limit) {
        try {
            if (listSubs.size() == 0) {
                return new ArrayList<VacationRequestEntity>();
            }
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByManager", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("managerId", (Object)managerId).setParameter("listSubs", listSubs).setParameter("currentDate", (Object)new Date(System.currentTimeMillis() - 86400000L)).getResultList();
            }
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByManager", VacationRequestEntity.class).setParameter("managerId", (Object)managerId).setParameter("listSubs", listSubs).setParameter("currentDate", (Object)new Date(System.currentTimeMillis() - 86400000L)).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }
}

