/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.dao;

import java.util.List;
import javax.persistence.NoResultException;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.rhmanagement.entity.UserRHDataEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserRHDataDAO
extends GenericDAOJPAImpl<UserRHDataEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(UserRHDataDAO.class);

    public UserRHDataEntity getUserRHDataDAOByUserId(String userId) throws Exception {
        try {
            return (UserRHDataEntity)this.getEntityManager().createNamedQuery("userRHDataEntity.findByUserId", UserRHDataEntity.class).setParameter("userId", (Object)userId).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get user data ", (Throwable)e);
            throw e;
        }
    }

    public List<UserRHDataEntity> getAllUsersRhData(int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("userRHDataEntity.findAll", UserRHDataEntity.class).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("userRHDataEntity.findAll", UserRHDataEntity.class).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get rh data with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<UserRHDataEntity> getUsersRhDataByStatus(boolean active, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("userRHDataEntity.findByStatus", UserRHDataEntity.class).setParameter("active", (Object)active).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("userRHDataEntity.findByStatus", UserRHDataEntity.class).setParameter("active", (Object)active).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get rh data with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<UserRHDataEntity> getSubordonateByUserId(String userId) {
        try {
            return this.getEntityManager().createNamedQuery("userRHDataEntity.findSubordonateByUserId", UserRHDataEntity.class).setParameter("userId", (Object)userId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get Subordonates", (Throwable)e);
            throw e;
        }
    }

    public List<UserRHDataEntity> getFSubordonateByUserId(String userId) {
        try {
            return this.getEntityManager().createNamedQuery("userRHDataEntity.findFSubordonateByUserId", UserRHDataEntity.class).setParameter("userId", (Object)userId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get Subordonates", (Throwable)e);
            throw e;
        }
    }

    public List<UserRHDataEntity> getHSubordonateByUserId(String userId) {
        try {
            return this.getEntityManager().createNamedQuery("userRHDataEntity.findHSubordonateByUserId", UserRHDataEntity.class).setParameter("userId", (Object)userId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get Subordonates", (Throwable)e);
            throw e;
        }
    }
}

