/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.integration.notification;

import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.LinkedList;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.rhmanagement.dto.VacationRequestWithManagersDTO;
import org.exoplatform.rhmanagement.services.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.manager.IdentityManager;

public class RequestCreatedPlugin
extends BaseNotificationPlugin {
    public static final ArgumentLiteral<VacationRequestWithManagersDTO> REQUEST = new ArgumentLiteral(VacationRequestWithManagersDTO.class, "request");
    private static final Log LOG = ExoLogger.getLogger(RequestCreatedPlugin.class);
    public static final String ID = "RequestCreatedPlugin";
    IdentityManager identityManager;

    public RequestCreatedPlugin(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.identityManager = identityManager;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        SimpleDateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
        VacationRequestWithManagersDTO obj = (VacationRequestWithManagersDTO)ctx.value(REQUEST);
        HashSet<String> receivers = new HashSet<String>();
        try {
            for (String manager : obj.getManagers()) {
                receivers.add(manager);
            }
            for (User rhManager : Utils.getRhManagers()) {
                if (receivers.contains(rhManager.getUserName())) continue;
                receivers.add(rhManager.getUserName());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        String userId = obj.getVacationRequestDTO().getUserId();
        receivers.remove(userId);
        StringBuilder activityId = new StringBuilder(userId);
        activityId.append("-").append(obj.getVacationRequestDTO().getId());
        String vacationUrl = CommonsUtils.getCurrentDomain() + "/portal/dw/rh-management?rid=" + obj.getVacationRequestDTO().getId();
        return NotificationInfo.instance().setFrom(userId).to(new LinkedList(receivers)).with("creator", userId).with("from", String.valueOf(obj.getVacationRequestDTO().getFromDate().getTime())).with("to", String.valueOf(obj.getVacationRequestDTO().getToDate().getTime())).with("vacationUrl", vacationUrl).with("activityId", activityId.toString()).key(this.getKey()).end();
    }
}

