/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.fileupload.FileItem;
import org.exoplatform.agenda.model.AgendaUserSettings;
import org.exoplatform.agenda.service.AgendaUserSettingsService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.rhmanagement.dto.BalanceHistoryDTO;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.rhmanagement.dto.ValidatorDTO;
import org.exoplatform.rhmanagement.services.BalanceHistoryService;
import org.exoplatform.rhmanagement.services.OfficialVacationService;
import org.exoplatform.rhmanagement.services.ValidatorService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class Utils {
    private static Log log = ExoLogger.getLogger(Utils.class);
    private static final String HR_MANAGERS_GROUP = "exo.hrmanagement.managers.group";
    private static final String HR_MANAGERS_GROUP_DEFAULT = "/rh-managers";
    public static final String ALL = "all";
    public static final String ACTIVE = "active";
    public static final String WAITING = "waiting";
    public static final String APPROVED = "approved";
    public static final String DECLINED = "declined";
    public static final String PENDING = "pending";
    public static final String CANCELED = "canceled";
    public static final String VALIDATED = "validated";
    public static final String COMMENT = "comment";
    public static final String HISTORY = "history";
    public static final String SICK = "sick";
    public static final String HOLIDAY = "holiday";
    public static final String LEAVE = "leave";
    public static final String EMPLOYEES_SPACE = "exo.hrmanagement.employees.space";
    public static final String EMPLOYEES_SPACE_DEFAULT = "exo_employees";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(FileItem item, String typeFolder, String parentNode) {
        RepositoryService repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            Node applicationDataNode;
            Session session = sessionProvider.getSession("collaboration", repositoryService.getCurrentRepository());
            Node rootNode = session.getRootNode();
            if (!rootNode.hasNode("Application Data")) {
                rootNode.addNode("Application Data", "nt:folder");
                session.save();
            }
            if (!(rootNode = rootNode.getNode("Application Data")).hasNode("hrmanagement")) {
                rootNode.addNode("hrmanagement", "nt:folder");
                session.save();
            }
            if (!(applicationDataNode = rootNode.getNode("hrmanagement")).hasNode(typeFolder)) {
                applicationDataNode.addNode(typeFolder, "nt:folder");
                session.save();
            }
            Node tFolder = applicationDataNode.getNode(typeFolder);
            Node fFolder = null;
            if (!tFolder.hasNode(parentNode)) {
                tFolder.addNode(parentNode, "nt:folder");
                session.save();
            }
            fFolder = tFolder.getNode(parentNode);
            Node fileNode = fFolder.addNode(item.getName(), "nt:file");
            Node jcrContent = fileNode.addNode("jcr:content", "nt:resource");
            jcrContent.setProperty("jcr:data", item.getInputStream());
            jcrContent.setProperty("jcr:lastModified", Calendar.getInstance());
            jcrContent.setProperty("jcr:encoding", "UTF-8");
            jcrContent.setProperty("jcr:mimeType", item.getContentType());
            fFolder.save();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String path) {
        RepositoryService repositoryService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            Session session = sessionProvider.getSession("collaboration", repositoryService.getCurrentRepository());
            Node rootNode = session.getRootNode();
            if (rootNode.hasNode(path)) {
                Node att = rootNode.getNode(path);
                att.remove();
                session.save();
            }
        }
    }

    public static User[] getRhManagers() {
        String groupId = System.getProperty(HR_MANAGERS_GROUP);
        if (groupId == null) {
            groupId = HR_MANAGERS_GROUP_DEFAULT;
        }
        OrganizationService organizationService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
        UserHandler userHandler = organizationService.getUserHandler();
        ListAccess allManagers = null;
        try {
            allManagers = userHandler.findUsersByGroupId(groupId);
            return (User[])allManagers.load(0, allManagers.getSize());
        }
        catch (Exception e) {
            log.error((Object)" ERROR get manager ", (Throwable)e);
            return null;
        }
    }

    public static String formatDate(String date, TimeZone timezone) {
        if (date == null) {
            return null;
        }
        Calendar today = Calendar.getInstance(timezone);
        Calendar cal = Calendar.getInstance(timezone);
        cal.setTime(new Date(Long.parseLong(date)));
        String format = "MMM dd yyyy";
        if (cal.get(1) == today.get(1)) {
            format = "MMM dd";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(timezone);
        return df.format(cal.getTime());
    }

    public static TimeZone getUserTimezone(String username) {
        try {
            AgendaUserSettingsService agendaUserSettingsService = (AgendaUserSettingsService)CommonsUtils.getService(AgendaUserSettingsService.class);
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            Identity user = identityManager.getOrCreateIdentity("organization", username);
            AgendaUserSettings agendaUserSettings = agendaUserSettingsService.getAgendaUserSettings(Long.parseLong(user.getId()));
            return agendaUserSettings.getTimeZoneId() != null ? TimeZone.getTimeZone(agendaUserSettings.getTimeZoneId()) : TimeZone.getDefault();
        }
        catch (Exception e) {
            log.error((Object)"Can't retrieve timezone", (Throwable)e);
            return null;
        }
    }

    public static Boolean canView(VacationRequestDTO vr, String user) {
        if (user.equals(vr.getUserId())) {
            return true;
        }
        ValidatorService validatorService = (ValidatorService)CommonsUtils.getService(ValidatorService.class);
        for (ValidatorDTO validator : validatorService.getValidatorsByRequestId(vr.getId(), 0, 0)) {
            if (!user.equals(validator.getValidatorUserId())) continue;
            return true;
        }
        for (User manager : Utils.getRhManagers()) {
            if (!user.equals(manager.getUserName())) continue;
            return true;
        }
        return false;
    }

    public static void addBalanceHistoryEntry(VacationRequestDTO vReauqest, UserRHDataDTO userRHDataDTO, float intialHolidaysBalance, float intialSickBalance, String UpadateType, String upadater) {
        try {
            BalanceHistoryDTO balanceHistoryDTO = new BalanceHistoryDTO();
            balanceHistoryDTO.setUserId(vReauqest.getUserId());
            balanceHistoryDTO.setIntialHolidaysBalance(intialHolidaysBalance);
            balanceHistoryDTO.setIntialSickBalance(intialSickBalance);
            balanceHistoryDTO.setHolidaysBalance(userRHDataDTO.getHolidaysBalance());
            balanceHistoryDTO.setSickBalance(userRHDataDTO.getSickdaysBalance());
            balanceHistoryDTO.setVacationType(vReauqest.getType());
            balanceHistoryDTO.setVacationId(vReauqest.getId());
            balanceHistoryDTO.setDaysNumber(vReauqest.getDaysNumber());
            balanceHistoryDTO.setUpdateType(UpadateType);
            balanceHistoryDTO.setUpdaterId(upadater);
            BalanceHistoryService balanceHistoryService = (BalanceHistoryService)CommonsUtils.getService(BalanceHistoryService.class);
            balanceHistoryService.save(balanceHistoryDTO);
        }
        catch (Exception e) {
            log.error((Object)"Error when adding history entry", (Throwable)e);
        }
    }

    public static List<Date> getDaysBetweenDates(Date startdate, Date enddate) {
        SimpleDateFormat dt1 = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<Date> dates = new ArrayList<Date>();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startdate);
        GregorianCalendar endCalendar = new GregorianCalendar();
        endCalendar.setTime(enddate);
        ((Calendar)endCalendar).add(5, 1);
        while (calendar.getTime().before(endCalendar.getTime())) {
            Date result = calendar.getTime();
            dates.add(result);
            ((Calendar)calendar).add(5, 1);
            log.info((Object)("_____" + result.toString()));
        }
        return dates;
    }

    public static float calculateNumberOfDays(List<Date> oVacation, Date from, Date to) {
        float nb = 0.0f;
        Calendar cFrom = Calendar.getInstance();
        cFrom.setTime(from);
        Calendar cTo = Calendar.getInstance();
        cTo.setTime(to);
        Calendar c = cFrom;
        cTo.add(5, 1);
        while (c.before(cTo)) {
            if (1 != c.get(7) && 7 != c.get(7) && !Utils.isOffDay(c, oVacation)) {
                nb += 1.0f;
            }
            c.add(5, 1);
        }
        if (cFrom.get(11) > 12 && cFrom.get(11) < 19) {
            nb -= 0.5f;
        }
        if (cTo.get(11) < 15 && cTo.get(11) > 7) {
            nb -= 0.5f;
        }
        return nb;
    }

    public static Date getTodate(Date from, int nbr) {
        OfficialVacationService officialVacationService = (OfficialVacationService)CommonsUtils.getService(OfficialVacationService.class);
        int i = 1;
        List<Date> oVacation = officialVacationService.getOfficialVacationDays();
        Calendar date = Calendar.getInstance();
        date.setTime(from);
        while (i < nbr) {
            if (1 != date.get(7) && 7 != date.get(7) && !Utils.isOffDay(date, oVacation)) {
                ++i;
            }
            date.add(5, 1);
        }
        return date.getTime();
    }

    public static boolean isOffDay(Calendar date, List<Date> oVacation) {
        if (oVacation.size() == 0) {
            return false;
        }
        for (Date oDate : oVacation) {
            Calendar cDate = Calendar.getInstance();
            cDate.setTime(oDate);
            if (!Utils.sameDay(date, cDate)) continue;
            return true;
        }
        return false;
    }

    public static boolean sameDay(Calendar cal1, Calendar cal2) {
        return cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static float getEndYearBalance(float balance) {
        Calendar cDate = Calendar.getInstance();
        float b = (12 - cDate.get(2)) * 2;
        return b += balance;
    }
}

