/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services.rest;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.rhmanagement.dto.ValidatorDTO;
import org.exoplatform.rhmanagement.services.VacationRequestService;
import org.exoplatform.rhmanagement.services.ValidatorService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/rhrequest")
@Produces(value={"application/json"})
public class RequestRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RequestRestService.class);
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private VacationRequestService vacationRequestService;
    private ValidatorService validatorService;

    public RequestRestService(IdentityManager identityManager, SpaceService spaceService, VacationRequestService vacationRequestService, ValidatorService validatorService) {
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.vacationRequestService = vacationRequestService;
        this.validatorService = validatorService;
    }

    @GET
    @Path(value="users/find")
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    public Response find(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="nameToSearch") String nameToSearch, @QueryParam(value="spaceURL") String spaceURL, @QueryParam(value="currentUser") String currentUser) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            List profiles;
            JSONArray users = new JSONArray();
            Space space = this.spaceService.getSpaceByUrl(spaceURL);
            if (space != null && (profiles = this.getSpaceMembersProfiles(space).stream().filter(a -> a.getFullName().toLowerCase().contains(nameToSearch.toLowerCase())).collect(Collectors.toList())) != null && profiles.size() > 0) {
                for (Profile profile : profiles) {
                    JSONObject user = new JSONObject();
                    user.put("value", (Object)profile.getIdentity().getRemoteId());
                    user.put("type", (Object)"user");
                    user.put("invalid", false);
                    user.put("order", (Object)"1");
                    if (profile.getAvatarUrl() != null) {
                        user.put("avatarUrl", (Object)profile.getAvatarUrl());
                    } else {
                        user.put("avatarUrl", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
                    }
                    user.put("text", (Object)(profile.getFullName() + " (" + profile.getIdentity().getRemoteId() + ")"));
                    users.put((Object)user);
                }
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("options", (Object)users);
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getevents")
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    public Response getEvents(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        SimpleDateFormat dt1 = new SimpleDateFormat("yyyy-MM-dd");
        try {
            List<ValidatorDTO> validators;
            JSONArray events = new JSONArray();
            List<VacationRequestDTO> vrs = this.vacationRequestService.getVacationRequestsByUserId(currentUser, 0, 100);
            if (vrs.size() > 0) {
                for (VacationRequestDTO vr : vrs) {
                    JSONObject event = new JSONObject();
                    event.put("id", vr.getId());
                    event.put("title", (Object)vr.getUserFullName());
                    event.put("start", (Object)dt1.format(vr.getFromDate()));
                    event.put("end", (Object)dt1.format(vr.getToDate()));
                    if ("validated".equals(vr.getStatus())) {
                        event.put("backgroundColor", (Object)"green");
                    }
                    if ("approved".equals(vr.getStatus())) {
                        event.put("backgroundColor", (Object)"blue");
                    }
                    if ("declined".equals(vr.getStatus()) || "canceled".equals(vr.getStatus())) {
                        event.put("backgroundColor", (Object)"red");
                    }
                    if ("pending".equals(vr.getStatus())) {
                        event.put("backgroundColor", (Object)"orange");
                    }
                    events.put((Object)event);
                }
            }
            if ((validators = this.validatorService.getValidatorsByValidatorUserId(currentUser, 0, 100)).size() > 0) {
                for (ValidatorDTO validator : validators) {
                    VacationRequestDTO requestDTO = this.vacationRequestService.getVacationRequest(validator.getRequestId());
                    if (requestDTO == null) continue;
                    JSONObject event = new JSONObject();
                    event.put("id", requestDTO.getId());
                    event.put("title", (Object)requestDTO.getUserFullName());
                    event.put("start", (Object)dt1.format(requestDTO.getFromDate()));
                    event.put("end", (Object)dt1.format(requestDTO.getFromDate()));
                    if ("validated".equals(requestDTO.getStatus())) {
                        event.put("backgroundColor", (Object)"green");
                    }
                    if ("approved".equals(requestDTO.getStatus())) {
                        event.put("backgroundColor", (Object)"blue");
                    }
                    if ("declined".equals(requestDTO.getStatus()) || "canceled".equals(requestDTO.getStatus())) {
                        event.put("backgroundColor", (Object)"red");
                    }
                    if ("pending".equals(requestDTO.getStatus())) {
                        event.put("backgroundColor", (Object)"orange");
                    }
                    events.put((Object)event);
                }
            }
            return Response.ok((Object)events.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    private List<Profile> getSpaceMembersProfiles(Space space) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (String userId : space.getMembers()) {
            Profile userProfile = this.identityManager.getOrCreateIdentity("organization", userId, false).getProfile();
            profiles.add(userProfile);
        }
        return profiles;
    }
}

