/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.rhmanagement.dao.UserRHDataDAO;
import org.exoplatform.rhmanagement.dto.EmployeesDTO;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.entity.UserRHDataEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDataService {
    private final Logger LOG = LoggerFactory.getLogger(UserDataService.class);
    private UserRHDataDAO userRHDataDAO = new UserRHDataDAO();
    private IdentityManager identityManager;

    public UserDataService(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    public UserRHDataDTO save(UserRHDataDTO entity) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' is null");
        }
        UserRHDataEntity userRHDataEntity = null;
        try {
            UserRHDataDTO userRHDataDTO = this.getUserRHDataByUserId(entity.getUserId());
            if (userRHDataDTO != null) {
                userRHDataEntity = (UserRHDataEntity)this.userRHDataDAO.update(this.convert(entity));
            } else {
                entity.setCreationDate(new Date());
                userRHDataEntity = (UserRHDataEntity)this.userRHDataDAO.create(this.convert(entity));
            }
        }
        catch (Exception e) {
            entity.setCreationDate(new Date());
            userRHDataEntity = (UserRHDataEntity)this.userRHDataDAO.create(this.convert(entity));
        }
        return this.convert(userRHDataEntity);
    }

    public void remove(UserRHDataDTO entity) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' = + " + entity + " or 'entity.id' is null");
        }
        this.userRHDataDAO.delete(this.convert(entity));
    }

    public UserRHDataDTO getUserRHDataByUserId(String id) {
        try {
            return this.convert(this.userRHDataDAO.getUserRHDataDAOByUserId(id));
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<EmployeesDTO> getAllUsersRhData(int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getAllUsersRhData - Parameter 'offset' must be positive");
        }
        List<UserRHDataEntity> entities = this.userRHDataDAO.getAllUsersRhData(offset, limit);
        ArrayList<EmployeesDTO> dtos = new ArrayList<EmployeesDTO>();
        for (UserRHDataEntity entity : entities) {
            Identity id = this.identityManager.getOrCreateIdentity("organization", entity.getUserId(), false);
            if (id == null) continue;
            Profile profile = id.getProfile();
            EmployeesDTO employeesDTO = new EmployeesDTO();
            employeesDTO.setId(entity.getId());
            employeesDTO.setUserId(entity.getUserId());
            employeesDTO.setName(profile.getFullName());
            employeesDTO.setAvatar(profile.getAvatarUrl());
            employeesDTO.setEmail(profile.getEmail());
            employeesDTO.setJobTitle(profile.getPosition());
            employeesDTO.setGender(profile.getGender());
            if (profile.getPhones() != null && profile.getPhones().size() > 0) {
                String phones = "";
                for (Map map : profile.getPhones()) {
                    String phone = "";
                    Iterator iterator = map.entrySet().iterator();
                    if (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        phone = (String)entry.getValue();
                    }
                    phones = phones + phone + " , ";
                }
                employeesDTO.setPhone(phones);
            } else {
                employeesDTO.setPhone("");
            }
            employeesDTO.setHrData(this.convert(entity));
            dtos.add(employeesDTO);
        }
        return dtos;
    }

    public List<UserRHDataDTO> getAllRhData(int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getAllUsersRhData - Parameter 'offset' must be positive");
        }
        ArrayList<UserRHDataDTO> dtos = new ArrayList<UserRHDataDTO>();
        for (UserRHDataEntity entity : this.userRHDataDAO.getAllUsersRhData(offset, limit)) {
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    private UserRHDataEntity convert(UserRHDataDTO dto) {
        UserRHDataEntity entity = new UserRHDataEntity();
        entity.setId(dto.getId());
        entity.setUserId(dto.getUserId());
        entity.setCin(dto.getCin());
        entity.setHolidaysBalance(dto.getHolidaysBalance());
        entity.setSickdaysBalance(dto.getSickdaysBalance());
        entity.setSocialSecNumber(dto.getSocialSecNumber());
        entity.setHrId(dto.getHrId());
        entity.setBirthDay(dto.getBirthDay());
        entity.setSituation(dto.getSituation());
        entity.setNbChildren(dto.getNbChildren());
        entity.setTeam(dto.getTeam());
        entity.setBankId(dto.getBankId());
        entity.setStartDate(dto.getStartDate());
        entity.setLeaveDate(dto.getLeaveDate());
        entity.setContract(dto.getContract());
        entity.setContractStartDate(dto.getContractStartDate());
        entity.setContractEndDate(dto.getContractEndDate());
        entity.setInsuranceId(dto.getInsuranceId());
        entity.setMyeXoUrl(dto.getMyeXoUrl());
        entity.setOthers(dto.getOthers());
        entity.setAddress(dto.getAddress());
        entity.setCreationDate(dto.getCreationDate());
        return entity;
    }

    private UserRHDataDTO convert(UserRHDataEntity entity) {
        UserRHDataDTO dto = new UserRHDataDTO();
        dto.setId(entity.getId());
        dto.setUserId(entity.getUserId());
        dto.setCin(entity.getCin());
        dto.setHolidaysBalance(entity.getHolidaysBalance());
        dto.setSickdaysBalance(entity.getSickdaysBalance());
        dto.setSocialSecNumber(entity.getSocialSecNumber());
        dto.setHrId(entity.getHrId());
        dto.setBirthDay(entity.getBirthDay());
        dto.setSituation(entity.getSituation());
        dto.setNbChildren(entity.getNbChildren());
        dto.setTeam(entity.getTeam());
        dto.setBankId(entity.getBankId());
        dto.setStartDate(entity.getStartDate());
        dto.setLeaveDate(entity.getLeaveDate());
        dto.setContract(entity.getContract());
        dto.setContractStartDate(entity.getContractStartDate());
        dto.setContractEndDate(entity.getContractEndDate());
        dto.setInsuranceId(entity.getInsuranceId());
        dto.setMyeXoUrl(entity.getMyeXoUrl());
        dto.setAddress(entity.getAddress());
        dto.setOthers(entity.getOthers());
        dto.setCreationDate(entity.getCreationDate());
        return dto;
    }
}

