/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.exoplatform.rhmanagement.dao.OfficialVacationDAO;
import org.exoplatform.rhmanagement.dto.OfficialVacationDTO;
import org.exoplatform.rhmanagement.entity.OfficialVacationEntity;
import org.exoplatform.rhmanagement.services.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfficialVacationService {
    private final Logger LOG = LoggerFactory.getLogger(OfficialVacationService.class);
    private OfficialVacationDAO officialVacationDAO = new OfficialVacationDAO();
    private List<String> officialVacationDays;

    public OfficialVacationDTO save(OfficialVacationDTO entity, boolean newCv) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' is null");
        }
        OfficialVacationEntity officialVacationEntity = null;
        officialVacationEntity = newCv ? (OfficialVacationEntity)this.officialVacationDAO.create(this.convert(entity)) : (OfficialVacationEntity)this.officialVacationDAO.update(this.convert(entity));
        return this.convert(officialVacationEntity);
    }

    public void remove(OfficialVacationDTO entity) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' = + " + entity + " or 'entity.id' is null");
        }
        this.officialVacationDAO.delete(this.convert(entity));
    }

    public List<OfficialVacationDTO> getOfficialVacations(int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getCommentsByRequestID - Parameter 'offset' must be positive");
        }
        List<OfficialVacationEntity> entities = this.officialVacationDAO.getOfficialVacations(offset, limit);
        ArrayList<OfficialVacationDTO> dtos = new ArrayList<OfficialVacationDTO>();
        for (OfficialVacationEntity entity : entities) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(entity.getBeginDate());
            calendar.set(10, 12);
            entity.setBeginDate(calendar.getTime());
            calendar.setTime(entity.getEndDate());
            calendar.set(10, 12);
            entity.setEndDate(calendar.getTime());
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public long getOfficialVacationsCount() {
        return this.officialVacationDAO.getOfficialVacationsCount();
    }

    public OfficialVacationDTO getOfficialVacationsById(long id) {
        return this.convert(this.officialVacationDAO.getOfficialVacationById(id));
    }

    public List<Date> getOfficialVacationDays() {
        SimpleDateFormat dt1 = new SimpleDateFormat("yyyy-MM-dd");
        List<OfficialVacationEntity> entities = this.officialVacationDAO.getOfficialVacations(0, 0);
        ArrayList<Date> days = new ArrayList<Date>();
        for (OfficialVacationEntity entity : entities) {
            if (entity.getDaysNumber() == 1) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(entity.getBeginDate());
                calendar.set(10, 12);
                days.add(calendar.getTime());
                this.LOG.info("_____" + calendar.getTime().toString());
                continue;
            }
            if (entity.getDaysNumber() <= 1) continue;
            days.addAll(Utils.getDaysBetweenDates(entity.getBeginDate(), entity.getEndDate()));
        }
        return days;
    }

    private OfficialVacationEntity convert(OfficialVacationDTO dto) {
        OfficialVacationEntity entity = new OfficialVacationEntity();
        entity.setId(dto.getId());
        entity.setLabel(dto.getLabel());
        entity.setDaysNumber(dto.getDaysNumber());
        entity.setDescription(dto.getDescription());
        entity.setRecurrent(dto.getRecurrent());
        entity.setBeginDate(dto.getBeginDate());
        entity.setEndDate(dto.getEndDate());
        return entity;
    }

    private OfficialVacationDTO convert(OfficialVacationEntity entity) {
        OfficialVacationDTO dto = new OfficialVacationDTO();
        dto.setId(entity.getId());
        dto.setLabel(entity.getLabel());
        dto.setDaysNumber(entity.getDaysNumber());
        dto.setDescription(entity.getDescription());
        dto.setBeginDate(entity.getBeginDate());
        dto.setEndDate(entity.getEndDate());
        return dto;
    }
}

