/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services.listener;

import java.util.HashSet;
import java.util.Set;
import org.exoplatform.calendar.service.ExtendedCalendarService;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.rhmanagement.dto.ValidatorDTO;
import org.exoplatform.rhmanagement.integration.notification.RequestStatusChangedPlugin;
import org.exoplatform.rhmanagement.services.Utils;
import org.exoplatform.rhmanagement.services.ValidatorService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;

public class UpdateRequestListener
extends Listener<Set<String>, VacationRequestDTO> {
    private static final Log LOG = ExoLogger.getLogger(UpdateRequestListener.class);

    public void onEvent(Event event) throws Exception {
        String calId;
        VacationRequestDTO vr = (VacationRequestDTO)event.getData();
        String currentUser = (String)event.getSource();
        HashSet<String> receivers = new HashSet<String>();
        receivers.add(vr.getUserId());
        ValidatorService validatorService = (ValidatorService)CommonsUtils.getService(ValidatorService.class);
        for (ValidatorDTO validator : validatorService.getValidatorsByRequestId(vr.getId(), 0, 0)) {
            receivers.add(validator.getValidatorUserId());
        }
        if ("validated".equals(vr.getStatus()) || "canceled".equals(vr.getStatus()) || "approved".equals(vr.getStatus())) {
            try {
                for (User rh : Utils.getRhManagers()) {
                    if (rh.getUserName().equals(currentUser)) continue;
                    receivers.add(rh.getUserName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(RequestStatusChangedPlugin.REQUEST, (Object)vr).append(RequestStatusChangedPlugin.CURRENT_USER, (Object)currentUser).append(RequestStatusChangedPlugin.RECEIVERS, receivers);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"RequestStatusChangedPlugin"))).execute(ctx);
        if ("validated".equals(vr.getStatus())) {
            ExtendedCalendarService xCalendarService = (ExtendedCalendarService)CommonsUtils.getService(ExtendedCalendarService.class);
            String employeesSpace = System.getProperty("exo.hrmanagement.employees.space", "exo_employees");
            calId = employeesSpace + "_space_calendar";
            org.exoplatform.calendar.model.Event calendarEvent = new org.exoplatform.calendar.model.Event();
            calendarEvent.setId(calId + "_" + vr.getUserId() + "_" + vr.getId());
            calendarEvent.setEventCategoryId(vr.getType());
            calendarEvent.setEventCategoryName(vr.getType());
            calendarEvent.setSummary(vr.getUserFullName() + " " + vr.getType());
            calendarEvent.setFromDateTime(vr.getFromDate());
            calendarEvent.setToDateTime(vr.getToDate());
            calendarEvent.setEventType(org.exoplatform.calendar.model.Event.TYPE_EVENT);
            calendarEvent.setCalendarId(calId);
            xCalendarService.getEventHandler().saveEvent(calendarEvent);
        }
        if ("canceled".equals(vr.getStatus())) {
            ExtendedCalendarService xCalendarService = (ExtendedCalendarService)CommonsUtils.getService(ExtendedCalendarService.class);
            String employeesSpace = System.getProperty("exo.hrmanagement.employees.space", "exo_employees");
            calId = employeesSpace + "_space_calendar";
            xCalendarService.getEventHandler().removeEvent(calId + "_" + vr.getUserId() + "_" + vr.getId());
        }
    }
}

