/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.integration.notification;

import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.rhmanagement.services.ValidatorService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;

public class RequestStatusChangedPlugin
extends BaseNotificationPlugin {
    public static final ArgumentLiteral<VacationRequestDTO> REQUEST = new ArgumentLiteral(VacationRequestDTO.class, "request");
    public static final ArgumentLiteral<String> CURRENT_USER = new ArgumentLiteral(String.class, "currentUser");
    public static final ArgumentLiteral<Set> RECEIVERS = new ArgumentLiteral(Set.class, "receivers");
    private static final Log LOG = ExoLogger.getLogger(RequestStatusChangedPlugin.class);
    public static final String ID = "RequestStatusChangedPlugin";
    private ValidatorService validatorService;
    IdentityManager identityManager;

    public RequestStatusChangedPlugin(InitParams initParams, ValidatorService validatorService, IdentityManager identityManager) {
        super(initParams);
        this.validatorService = validatorService;
        this.identityManager = identityManager;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        SimpleDateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
        VacationRequestDTO obj = (VacationRequestDTO)ctx.value(REQUEST);
        String currentUser = (String)ctx.value(CURRENT_USER);
        Set receivers = (Set)ctx.value(RECEIVERS);
        String userId = currentUser;
        receivers.remove(userId);
        StringBuilder activityId = new StringBuilder(userId);
        activityId.append("-").append(obj.getId());
        String vacationUrl = CommonsUtils.getCurrentDomain() + "/portal/dw/rh-management?rid=" + obj.getId();
        return NotificationInfo.instance().setFrom(userId).to(new LinkedList(receivers)).with("creator", userId).with("from", String.valueOf(obj.getFromDate().getTime())).with("to", String.valueOf(obj.getToDate().getTime())).with("userName", obj.getUserId().toString()).with("vacationUrl", vacationUrl).with("activityId", activityId.toString()).key(this.getKey()).end();
    }
}

