/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services.jobs;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.rhmanagement.dto.OfficialVacationDTO;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.integration.notification.HRBirthdayNotificationPlugin;
import org.exoplatform.rhmanagement.integration.notification.HRContractAnniversaryNotificationPlugin;
import org.exoplatform.rhmanagement.services.OfficialVacationService;
import org.exoplatform.rhmanagement.services.UserDataService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class NotificationsJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(NotificationsJob.class);
    private UserDataService userDataService = (UserDataService)CommonsUtils.getService(UserDataService.class);
    private OfficialVacationService officialVacationService = (OfficialVacationService)CommonsUtils.getService(OfficialVacationService.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        LOG.info((Object)"Notifications Job started");
        LOG.info((Object)"Check Anniversary Notifs");
        Long start = System.currentTimeMillis();
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        List<UserRHDataDTO> employees = this.userDataService.getRhDataByStatus(true, 0, 0);
        Calendar now = Calendar.getInstance();
        for (UserRHDataDTO employee : employees) {
            NotificationContext ctx;
            String message;
            Profile userProfile;
            long rem;
            Calendar cal;
            if (employee.getBirthDay() != null) {
                cal = Calendar.getInstance();
                cal.setTime(employee.getBirthDay());
                cal.set(1, now.get(1));
                rem = this.daysBetween(cal, now);
                if (rem == 0L) {
                    userProfile = identityManager.getOrCreateIdentity("organization", employee.getUserId()).getProfile();
                    message = "The Birthday of " + userProfile.getFullName() + "will be in " + rem + " days";
                    ctx = NotificationContextImpl.cloneInstance().append(HRBirthdayNotificationPlugin.EMPLOYEE, (Object)employee).append(HRBirthdayNotificationPlugin.NOTIF_TYPE, (Object)message);
                    ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"HRBirthdayNotificationPlugin"))).execute(ctx);
                }
            }
            if (employee.getContractStartDate() == null) continue;
            cal = Calendar.getInstance();
            cal.setTime(employee.getContractStartDate());
            cal.set(1, now.get(1));
            rem = this.daysBetween(cal, now);
            if (rem != 0L) continue;
            LOG.info((Object)("contact annif for " + employee.getUserId()));
            userProfile = identityManager.getOrCreateIdentity("organization", employee.getUserId()).getProfile();
            message = "The Anniversary of contract of " + userProfile.getFullName() + "will be in " + rem + " days";
            ctx = NotificationContextImpl.cloneInstance().append(HRContractAnniversaryNotificationPlugin.EMPLOYEE, (Object)employee).append(HRContractAnniversaryNotificationPlugin.NOTIF_TYPE, (Object)message);
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"HRContractAnniversaryNotificationPlugin"))).execute(ctx);
        }
        LOG.info((Object)("Notifications Job ended in " + (System.currentTimeMillis() - start) + " ms"));
    }

    public long daysBetween(Calendar d1, Calendar d2) {
        return Math.round(((float)d2.getTime().getTime() - (float)d1.getTime().getTime()) / 8.64E7f);
    }

    public ExoSocialActivity createActivity(OfficialVacationDTO oVacation) {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy");
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        String userId = "root";
        String employeesSpace = System.getProperty("exo.hrmanagement.employees.space", "exo_employees");
        Space space = spaceService.getSpaceByGroupId(employeesSpace);
        String dates = "";
        Calendar from = Calendar.getInstance();
        from.setTime(oVacation.getBeginDate());
        Calendar to = Calendar.getInstance();
        to.setTime(oVacation.getEndDate());
        long rem = this.daysBetween(from, to);
        dates = rem > 0L ? "from " + formatter.format(from.getTime()) + " to " + formatter.format(to.getTime()) : formatter.format(from.getTime());
        if (space == null) {
            LOG.warn((Object)"Space not found");
        } else {
            Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
            Identity posterIdentity = identityManager.getOrCreateIdentity("organization", userId, false);
            if (posterIdentity != null && spaceIdentity != null) {
                ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
                activity.setType("DEFAULT_ACTIVITY");
                activity.setTitle("<span id='rhActivity'>\nHi,  <br/>\nThe office will be closed " + dates + " for \"" + oVacation.getDescription() + "\"");
                activity.setUserId(posterIdentity.getId());
                return activityManager.saveActivity(spaceIdentity, (ExoSocialActivity)activity);
            }
            LOG.warn((Object)"Not able to create the activity, the Poster or Space Identity is missing");
        }
        return null;
    }
}

