/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.integration.notification;

import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.rhmanagement.dto.ValidatorDTO;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;

public class RequestRepliedPlugin
extends BaseNotificationPlugin {
    public static final ArgumentLiteral<ValidatorDTO> VALIDATOR = new ArgumentLiteral(ValidatorDTO.class, "validator");
    public static final ArgumentLiteral<Set> RECEIVERS = new ArgumentLiteral(Set.class, "receivers");
    public static final ArgumentLiteral<VacationRequestDTO> VACATION_REQUEST = new ArgumentLiteral(VacationRequestDTO.class, "vacationRequest");
    private static final Log LOG = ExoLogger.getLogger(RequestRepliedPlugin.class);
    public static final String ID = "RequestRepliedPlugin";
    IdentityManager identityManager;

    public RequestRepliedPlugin(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.identityManager = identityManager;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        SimpleDateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
        ValidatorDTO obj = (ValidatorDTO)ctx.value(VALIDATOR);
        VacationRequestDTO vacationRequest = (VacationRequestDTO)ctx.value(VACATION_REQUEST);
        Set receivers = (Set)ctx.value(RECEIVERS);
        String userId = obj.getValidatorUserId();
        receivers.remove(userId);
        StringBuilder activityId = new StringBuilder(userId);
        activityId.append("-").append(obj.getRequestId());
        String vacationUrl = CommonsUtils.getCurrentDomain() + "/portal/dw/rh-management?rid=" + obj.getRequestId();
        return NotificationInfo.instance().setFrom(userId).to(new LinkedList(receivers)).with("creator", userId).with("from", String.valueOf(vacationRequest.getFromDate().getTime())).with("to", String.valueOf(vacationRequest.getToDate().getTime())).with("userName", vacationRequest.getUserId().toString()).with("vacationUrl", vacationUrl).with("activityId", activityId.toString()).key(this.getKey()).end();
    }
}

