/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.portlet.rhProfileInfo;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.persistence.NoResultException;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.services.UserDataService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.manager.IdentityManager;

@SessionScoped
public class RHProfileController {
    private static Log log = ExoLogger.getLogger(RHProfileController.class);
    ResourceBundle bundle;
    @Inject
    IdentityManager identityManager;
    @Inject
    UserDataService userDataService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    private String bundleString;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public UserRHDataDTO loadUserRhData() {
        block4: {
            try {
                String currentUserName = "";
                PortalRequestContext portalRequestContext = (PortalRequestContext)PortalRequestContext.getCurrentInstance();
                String requestPath = "/" + portalRequestContext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
                ExoRouter.Route route = ExoRouter.route((String)requestPath);
                if (route == null) break block4;
                UserRHDataDTO userRHDataDTO = new UserRHDataDTO();
                currentUserName = (String)route.localArgs.get("streamOwnerId");
                try {
                    userRHDataDTO = this.userDataService.getUserRHDataByUserId(currentUserName);
                }
                catch (NoResultException e) {
                    userRHDataDTO.setUserId(currentUserName);
                }
                return userRHDataDTO;
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public UserRHDataDTO saveUserData(@Jackson UserRHDataDTO obj) {
        if (obj.getUserId() == null) {
            try {
                String currentUserName = "";
                PortalRequestContext portalRequestContext = (PortalRequestContext)PortalRequestContext.getCurrentInstance();
                String requestPath = "/" + portalRequestContext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
                ExoRouter.Route route = ExoRouter.route((String)requestPath);
                if (route != null) {
                    currentUserName = (String)route.localArgs.get("streamOwnerId");
                    obj.setUserId(currentUserName);
                }
            }
            catch (Throwable e) {
                log.error((Object)"Can't get UserID");
                return obj;
            }
        }
        return this.userDataService.save(obj);
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.rh-management", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }
}

