/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.portlet.rhRequestsHistory;

import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.inject.Inject;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.impl.common.JSON;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.rhmanagement.dto.BalanceHistoryDTO;
import org.exoplatform.rhmanagement.dto.EmployeesDTO;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.services.BalanceHistoryService;
import org.exoplatform.rhmanagement.services.UserDataService;
import org.exoplatform.rhmanagement.services.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;

public class RhRequestsHistoryController {
    private static Log LOG = ExoLogger.getLogger(RhRequestsHistoryController.class);
    private String bundleString;
    ResourceBundle bundle;
    @Inject
    UserDataService userDataService;
    @Inject
    IdentityManager identityManager;
    @Inject
    OrganizationService orgService;
    @Inject
    BalanceHistoryService balanceHistoryService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<BalanceHistoryDTO> getBalanceHistoryByUserId(String userId, Long from, Long to) {
        try {
            if (userId.equals("")) {
                return this.balanceHistoryService.getBalanceHistoryByDate(from.longValue(), to.longValue(), 0, 0);
            }
            return this.balanceHistoryService.getBalanceHistoryByUserId(userId, from.longValue(), to.longValue(), 0, 0);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public EmployeesDTO getUser(String userId) {
        try {
            UserHandler uh = this.orgService.getUserHandler();
            if (uh.findUserByName(userId) == null) {
                return null;
            }
            Profile profile = this.identityManager.getOrCreateIdentity("organization", userId).getProfile();
            EmployeesDTO employee = new EmployeesDTO();
            employee.setName(profile.getFullName());
            employee.setUserId(userId);
            employee.setEmail(profile.getEmail());
            employee.setGender(profile.getGender());
            employee.setJobTitle(profile.getPosition());
            employee.setAvatar(profile.getAvatarUrl());
            UserRHDataDTO userRHDataDTO = this.userDataService.getUserRHDataByUserId(userId);
            if (userRHDataDTO == null) {
                userRHDataDTO = new UserRHDataDTO();
                userRHDataDTO.setUserId(userId);
            }
            employee.setHrData(userRHDataDTO);
            return employee;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle() {
        try {
            if (!PropertyManager.isDevelopping() && this.bundleString != null && this.getResourceBundle().getLocale().equals(PortalRequestContext.getCurrentInstance().getLocale())) {
                return Response.ok((CharSequence)this.bundleString);
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            TimeZone userTimeZone = Utils.getUserTimezone((String)this.currentUser);
            data.set("userTimeZone", (Object)userTimeZone.toString());
            data.set("offset", (Object)userTimeZone.getOffset(new Date().getTime()));
            int offset = userTimeZone.getOffset(new Date().getTime()) / 3600000;
            String timeZone = (offset < 0 ? "-" : "") + String.format("%02d", Math.abs(offset)) + "00";
            data.set("timeZone", (Object)timeZone);
            data.set("currentUser", (Object)this.currentUser);
            this.bundleString = data.toString();
            return Response.ok((CharSequence)this.bundleString);
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting categories", e);
            return Response.status((int)500);
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.rh-management", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }
}

