/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.invoker;

import java.lang.reflect.Method;
import org.apache.commons.proxy.Invoker;
import org.apache.commons.proxy.ObjectProvider;

public class DuckTypingInvoker
implements Invoker {
    private final ObjectProvider targetProvider;

    public DuckTypingInvoker(ObjectProvider targetProvider) {
        this.targetProvider = targetProvider;
    }

    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Object target = this.targetProvider.getObject();
        Class<?> targetClass = target.getClass();
        try {
            Method targetMethod = targetClass.getMethod(method.getName(), method.getParameterTypes());
            if (method.getReturnType().isAssignableFrom(targetMethod.getReturnType())) {
                return targetMethod.invoke(target, arguments);
            }
            throw new UnsupportedOperationException("Target type " + targetClass.getName() + " method has incompatible return type.");
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Target type " + targetClass.getName() + " does not have a method matching " + method + ".");
        }
    }
}

