/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sirona.configuration.ConfigurationProvider;

public class FileConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOGGER = Logger.getLogger(FileConfigurationProvider.class.getName());
    private final String name;

    public FileConfigurationProvider(String name) {
        this.name = name;
    }

    @Override
    public int ordinal() {
        return 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties configuration() {
        Properties properties = new Properties();
        String filename = System.getProperty("org.apache.sirona.configuration." + this.name, this.name);
        if (new File(filename).exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(filename);
                properties.load(fileInputStream);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                this.closeQuietly(fileInputStream);
            }
        } else {
            InputStream stream = FileConfigurationProvider.class.getClassLoader().getResourceAsStream(filename);
            if (stream != null) {
                try {
                    properties.load(stream);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return properties;
    }

    private void closeQuietly(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "fail to close inputStream: " + e.getMessage(), e);
        }
    }
}

