/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.configuration.predicate;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.sirona.configuration.predicate.Predicate;
import org.apache.sirona.spi.SPI;

public final class PredicateEvaluator {
    private static final String NOT = "!";
    private static final char SEPARATOR = ':';
    private final Map<String, Predicate> predicates = new HashMap<String, Predicate>();

    public PredicateEvaluator(String configuration, String sep) {
        if (configuration != null && !configuration.isEmpty()) {
            String[] segments;
            PrefixPredicate prefixPredicate = new PrefixPredicate();
            SuffixPredicate suffixPredicate = new SuffixPredicate();
            RegexPredicate regexPredicate = new RegexPredicate();
            this.predicates.put(prefixPredicate.prefix(), prefixPredicate);
            this.predicates.put(suffixPredicate.prefix(), suffixPredicate);
            this.predicates.put(regexPredicate.prefix(), regexPredicate);
            for (Predicate predicate : SPI.INSTANCE.find(Predicate.class, PredicateEvaluator.class.getClassLoader())) {
                this.predicates.put(predicate.prefix(), predicate);
            }
            for (String segment : segments = configuration.split(sep)) {
                String trim = segment.trim();
                int separator = trim.indexOf(58);
                if (separator <= 0 || trim.length() <= separator) {
                    throw new IllegalArgumentException("Need to specify a prefix, available are:" + this.predicates.keySet());
                }
                String prefix = trim.substring(0, separator);
                Predicate predicate = this.predicates.get(prefix);
                if (predicate == null) {
                    throw new IllegalArgumentException("Can't find prefix '" + prefix + "'");
                }
                String value = trim.substring(separator + 1);
                if (!value.startsWith(NOT)) {
                    predicate.addConfiguration(value, true);
                    continue;
                }
                predicate.addConfiguration(value.substring(1), false);
            }
        }
    }

    public boolean matches(String value) {
        for (Predicate predicate : this.predicates.values()) {
            if (!predicate.matches(value)) continue;
            return true;
        }
        return false;
    }

    private static class RegexPredicate
    implements Predicate {
        private final Map<Pattern, Boolean> patterns = new HashMap<Pattern, Boolean>();

        private RegexPredicate() {
        }

        @Override
        public String prefix() {
            return "regex";
        }

        @Override
        public boolean matches(String value) {
            for (Map.Entry<Pattern, Boolean> p : this.patterns.entrySet()) {
                if (!p.getKey().matcher(value).matches()) continue;
                return p.getValue();
            }
            return false;
        }

        @Override
        public void addConfiguration(String value, boolean negative) {
            this.patterns.put(Pattern.compile(value), negative);
        }
    }

    private static class PrefixPredicate
    implements Predicate {
        private final Map<String, Boolean> prefixes = new HashMap<String, Boolean>();

        private PrefixPredicate() {
        }

        @Override
        public String prefix() {
            return "prefix";
        }

        @Override
        public boolean matches(String value) {
            for (Map.Entry<String, Boolean> p : this.prefixes.entrySet()) {
                if (!value.startsWith(p.getKey())) continue;
                return p.getValue();
            }
            return false;
        }

        @Override
        public void addConfiguration(String value, boolean negative) {
            this.prefixes.put(value, negative);
        }
    }

    private static class SuffixPredicate
    implements Predicate {
        private final Map<String, Boolean> suffixes = new HashMap<String, Boolean>();

        private SuffixPredicate() {
        }

        @Override
        public String prefix() {
            return "suffix";
        }

        @Override
        public boolean matches(String value) {
            for (Map.Entry<String, Boolean> p : this.suffixes.entrySet()) {
                if (!value.endsWith(p.getKey())) continue;
                return p.getValue();
            }
            return false;
        }

        @Override
        public void addConfiguration(String value, boolean negative) {
            this.suffixes.put(value, negative);
        }
    }
}

