/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.counters;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sirona.Role;
import org.apache.sirona.counters.Unit;

public interface Counter {
    public Key getKey();

    public void reset();

    public void add(double var1);

    public void add(double var1, Unit var3);

    public AtomicInteger currentConcurrency();

    public void updateConcurrency(int var1);

    public int getMaxConcurrency();

    public double getMax();

    public double getMin();

    public long getHits();

    public double getSum();

    public double getStandardDeviation();

    public double getVariance();

    public double getMean();

    public double getSecondMoment();

    public static class Key
    implements Serializable {
        private final String name;
        private final Role role;
        private int hash = Integer.MIN_VALUE;

        public Key(Role role, String name) {
            this.role = role;
            this.name = name;
        }

        public String toString() {
            return "name=" + this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.name.equals(key.name) && this.role.equals(key.role);
        }

        public int hashCode() {
            if (this.hash == Integer.MIN_VALUE) {
                this.hash = this.name.hashCode();
                this.hash = 31 * this.hash + this.role.hashCode();
            }
            return this.hash;
        }

        public String getName() {
            return this.name;
        }

        public Role getRole() {
            return this.role;
        }
    }
}

