/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.counters;

public class OptimizedStatistics {
    private long n = 0L;
    private double sum = 0.0;
    private double min = Double.NaN;
    private double max = Double.NaN;
    protected double m1 = Double.NaN;
    protected double dev = Double.NaN;
    protected double nDev = Double.NaN;
    protected double m2 = Double.NaN;

    public OptimizedStatistics() {
    }

    public OptimizedStatistics(long n, double sum, double min, double max, double m1, double dev, double nDev, double m2) {
        this.n = n;
        this.sum = sum;
        this.min = min;
        this.max = max;
        this.m1 = m1;
        this.dev = dev;
        this.nDev = nDev;
        this.m2 = m2;
    }

    public void addValue(double value) {
        if (this.n == 0L) {
            this.m1 = 0.0;
            this.m2 = 0.0;
        }
        ++this.n;
        this.sum += value;
        if (value < this.min || Double.isNaN(this.min)) {
            this.min = value;
        }
        if (value > this.max || Double.isNaN(this.max)) {
            this.max = value;
        }
        this.dev = value - this.m1;
        this.nDev = this.dev / (double)this.n;
        this.m1 += this.nDev;
        this.m2 += this.dev * this.nDev * (double)(this.n - 1L);
    }

    public void clear() {
        this.n = 0L;
        this.sum = 0.0;
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.dev = Double.NaN;
        this.nDev = Double.NaN;
        this.m1 = Double.NaN;
        this.m2 = Double.NaN;
    }

    public double getMean() {
        return this.m1;
    }

    public double getVariance() {
        if (this.n == 0L) {
            return Double.NaN;
        }
        if (this.n == 1L) {
            return 0.0;
        }
        return this.m2 / (double)(this.n - 1L);
    }

    public double getStandardDeviation() {
        if (this.n > 1L) {
            return Math.sqrt(this.getVariance());
        }
        if (this.n == 1L) {
            return 0.0;
        }
        return Double.NaN;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public long getN() {
        return this.n;
    }

    public double getSum() {
        return this.sum;
    }

    public double getSecondMoment() {
        return this.m2;
    }

    public OptimizedStatistics copy() {
        return new OptimizedStatistics(this.n, this.sum, this.min, this.max, this.m1, this.dev, this.nDev, this.m2);
    }
}

