/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.proxy.ObjectProvider;
import org.apache.commons.proxy.ProxyUtils;
import org.apache.commons.proxy.exception.ObjectProviderException;

public class CloningProvider
implements ObjectProvider {
    private final Cloneable cloneable;
    private Method cloneMethod;

    public CloningProvider(Cloneable cloneable) {
        this.cloneable = cloneable;
    }

    private synchronized Method getCloneMethod() {
        if (this.cloneMethod == null) {
            try {
                this.cloneMethod = this.cloneable.getClass().getMethod("clone", ProxyUtils.EMPTY_ARGUMENT_TYPES);
            }
            catch (NoSuchMethodException e) {
                throw new ObjectProviderException("Class " + this.cloneable.getClass().getName() + " does not have a public clone() method.");
            }
        }
        return this.cloneMethod;
    }

    public Object getObject() {
        try {
            return this.getCloneMethod().invoke((Object)this.cloneable, ProxyUtils.EMPTY_ARGUMENTS);
        }
        catch (IllegalAccessException e) {
            throw new ObjectProviderException("Class " + this.cloneable.getClass().getName() + " does not have a public clone() method.", e);
        }
        catch (InvocationTargetException e) {
            throw new ObjectProviderException("Attempt to clone object of type " + this.cloneable.getClass().getName() + " threw an exception.", e);
        }
    }
}

