/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.plugin.gauge;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.sirona.Role;
import org.apache.sirona.reporting.web.plugin.api.Regex;
import org.apache.sirona.reporting.web.plugin.api.Template;
import org.apache.sirona.reporting.web.plugin.api.graph.Graphs;
import org.apache.sirona.repositories.Repository;

public class GaugeEndpoints {
    private static final String UTF8 = "UTF-8";

    @Regex
    public Template home() {
        return new Template("gauge/home.vm").set("gauges", GaugeEndpoints.sortNames(Repository.INSTANCE.gauges()));
    }

    @Regex(value="/([^/]*)")
    public Template detail(String role) {
        return new Template("gauge/detail.vm").set("gauge", (Object)GaugeEndpoints.decode(role)).set("gauge64", (Object)role);
    }

    @Regex(value="/([^/]*)/([0-9]*)/([0-9]*)")
    public String jsonDetail(String base64Role, long start, long end) {
        String role = GaugeEndpoints.decode(base64Role);
        return Graphs.generateReport((String)role, (Role)Repository.INSTANCE.findGaugeRole(role), (long)start, (long)end);
    }

    private static String decode(String base64Role) {
        try {
            return new String(Base64.decodeBase64((String)URLDecoder.decode(base64Role, UTF8)));
        }
        catch (UnsupportedEncodingException e) {
            return base64Role;
        }
    }

    private static String encode(String role) {
        String base64 = Base64.encodeBase64URLSafeString((byte[])role.getBytes());
        try {
            return URLEncoder.encode(base64, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            return base64;
        }
    }

    private static Map<String, String> sortNames(Collection<Role> gauges) {
        TreeMap<String, String> names = new TreeMap<String, String>();
        for (Role gauge : gauges) {
            String name = gauge.getName();
            names.put(name, GaugeEndpoints.encode(name));
        }
        return names;
    }
}

