/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.repositories;

import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import org.apache.sirona.Role;
import org.apache.sirona.SironaException;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.configuration.ioc.IoCs;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.gauges.Gauge;
import org.apache.sirona.gauges.GaugeAware;
import org.apache.sirona.gauges.jvm.ActiveThreadGauge;
import org.apache.sirona.gauges.jvm.CPUGauge;
import org.apache.sirona.gauges.jvm.UsedMemoryGauge;
import org.apache.sirona.gauges.jvm.UsedNonHeapMemoryGauge;
import org.apache.sirona.repositories.Repository;
import org.apache.sirona.status.NodeStatus;
import org.apache.sirona.stopwatches.CounterStopWatch;
import org.apache.sirona.stopwatches.StopWatch;
import org.apache.sirona.store.DataStoreFactory;
import org.apache.sirona.store.counter.CollectorCounterStore;
import org.apache.sirona.store.counter.CounterDataStore;
import org.apache.sirona.store.gauge.CollectorGaugeDataStore;
import org.apache.sirona.store.gauge.CommonGaugeDataStore;
import org.apache.sirona.store.gauge.GaugeDataStore;
import org.apache.sirona.store.gauge.GaugeValuesRequest;
import org.apache.sirona.store.status.CollectorNodeStatusDataStore;
import org.apache.sirona.store.status.NodeStatusDataStore;
import org.apache.sirona.store.tracking.PathTrackingDataStore;

public class DefaultRepository
implements Repository {
    protected final CounterDataStore counterDataStore;
    protected final NodeStatusDataStore nodeStatusDataStore;
    protected final CommonGaugeDataStore gaugeDataStore;
    protected final PathTrackingDataStore pathTrackingDataStore;

    public DefaultRepository() {
        this(DefaultRepository.findCounterDataStore(), DefaultRepository.findGaugeDataStore(), DefaultRepository.findStatusDataStore(), DefaultRepository.findPathTrackingDataStore());
    }

    protected DefaultRepository(CounterDataStore counter, CommonGaugeDataStore gauge, NodeStatusDataStore status, PathTrackingDataStore pathTrackingDataStore) {
        this.counterDataStore = counter;
        this.gaugeDataStore = gauge;
        this.nodeStatusDataStore = status;
        this.pathTrackingDataStore = pathTrackingDataStore;
        if (CollectorCounterStore.class.isInstance(counter)) {
            IoCs.setSingletonInstance(CollectorCounterStore.class, counter);
        } else {
            IoCs.setSingletonInstance(CounterDataStore.class, counter);
        }
        if (CollectorGaugeDataStore.class.isInstance(gauge)) {
            IoCs.setSingletonInstance(CollectorGaugeDataStore.class, gauge);
        } else {
            IoCs.setSingletonInstance(GaugeDataStore.class, gauge);
        }
        if (CollectorNodeStatusDataStore.class.isInstance(status)) {
            IoCs.setSingletonInstance(CollectorNodeStatusDataStore.class, status);
        } else {
            IoCs.setSingletonInstance(NodeStatusDataStore.class, status);
        }
        if (Configuration.is("org.apache.sirona.core.gauge.activated", true)) {
            this.addGauge(new CPUGauge());
            this.addGauge(new UsedMemoryGauge());
            this.addGauge(new UsedNonHeapMemoryGauge());
            this.addGauge(new ActiveThreadGauge());
        }
    }

    private static NodeStatusDataStore findStatusDataStore() {
        NodeStatusDataStore status = null;
        try {
            status = IoCs.findOrCreateInstance(NodeStatusDataStore.class);
        }
        catch (SironaException sironaException) {
            // empty catch block
        }
        if (status == null) {
            status = IoCs.findOrCreateInstance(DataStoreFactory.class).getNodeStatusDataStore();
        }
        return status;
    }

    private static CommonGaugeDataStore findGaugeDataStore() {
        CommonGaugeDataStore gauge = null;
        try {
            gauge = IoCs.findOrCreateInstance(GaugeDataStore.class);
        }
        catch (SironaException e) {
            // empty catch block
        }
        if (gauge == null) {
            try {
                gauge = IoCs.findOrCreateInstance(CollectorGaugeDataStore.class);
            }
            catch (SironaException sironaException) {
                // empty catch block
            }
        }
        if (gauge == null) {
            gauge = IoCs.findOrCreateInstance(DataStoreFactory.class).getGaugeDataStore();
        }
        return gauge;
    }

    private static PathTrackingDataStore findPathTrackingDataStore() {
        PathTrackingDataStore pathTrackingDataStore = null;
        try {
            pathTrackingDataStore = IoCs.findOrCreateInstance(PathTrackingDataStore.class);
        }
        catch (SironaException sironaException) {
            // empty catch block
        }
        if (pathTrackingDataStore == null) {
            pathTrackingDataStore = IoCs.findOrCreateInstance(DataStoreFactory.class).getPathTrackingDataStore();
        }
        return pathTrackingDataStore;
    }

    private static CounterDataStore findCounterDataStore() {
        CounterDataStore counter = null;
        try {
            counter = IoCs.findOrCreateInstance(CounterDataStore.class);
        }
        catch (SironaException e) {
            // empty catch block
        }
        if (counter == null) {
            try {
                counter = IoCs.findOrCreateInstance(CollectorCounterStore.class);
            }
            catch (SironaException sironaException) {
                // empty catch block
            }
        }
        if (counter == null) {
            counter = IoCs.findOrCreateInstance(DataStoreFactory.class).getCounterDataStore();
        }
        return counter;
    }

    @Override
    public Counter getCounter(Counter.Key key) {
        return this.counterDataStore.getOrCreateCounter(key);
    }

    @Override
    public Collection<Counter> counters() {
        return this.counterDataStore.getCounters();
    }

    @Override
    public void clearCounters() {
        this.counterDataStore.clearCounters();
    }

    @Override
    public void reset() {
        this.clearCounters();
        this.nodeStatusDataStore.reset();
        for (Role g : this.gauges()) {
            this.gaugeDataStore.gaugeStopped(g);
        }
    }

    @Override
    public StopWatch start(Counter monitor) {
        return new CounterStopWatch(monitor);
    }

    @Override
    public SortedMap<Long, Double> getGaugeValues(long start, long end, Role role) {
        return this.gaugeDataStore.getGaugeValues(new GaugeValuesRequest(start, end, role));
    }

    @Override
    public Collection<Role> gauges() {
        return this.gaugeDataStore.gauges();
    }

    @Override
    public Role findGaugeRole(String name) {
        return this.gaugeDataStore.findGaugeRole(name);
    }

    @Override
    public void addGauge(Gauge gauge) {
        if (GaugeDataStore.class.isInstance(this.gaugeDataStore)) {
            ((GaugeDataStore)GaugeDataStore.class.cast(this.gaugeDataStore)).createOrNoopGauge(gauge.role());
        }
        if (GaugeAware.class.isInstance(this.gaugeDataStore)) {
            ((GaugeAware)GaugeAware.class.cast(this.gaugeDataStore)).addGauge(gauge);
        }
    }

    @Override
    public void stopGauge(Gauge gauge) {
        if (GaugeDataStore.class.isInstance(this.gaugeDataStore)) {
            ((GaugeDataStore)GaugeDataStore.class.cast(this.gaugeDataStore)).gaugeStopped(gauge.role());
        }
    }

    @Override
    public Map<String, NodeStatus> statuses() {
        return this.nodeStatusDataStore.statuses();
    }
}

