/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.store.counter;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.math.M2AwareStatisticalSummary;

public abstract class CollectorCounter
implements Counter,
Serializable {
    protected final Counter.Key key;
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected volatile int maxConcurrency = 0;
    protected volatile AtomicInteger concurrency = new AtomicInteger(0);
    protected M2AwareStatisticalSummary statistics;

    public CollectorCounter(Counter.Key key) {
        this.key = key;
        this.reset();
    }

    @Override
    public Counter.Key getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Lock workLock = this.lock.writeLock();
        workLock.lock();
        try {
            this.statistics = new M2AwareStatisticalSummary(Double.NaN, Double.NaN, 0L, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        finally {
            workLock.unlock();
        }
    }

    @Override
    public void add(double delta) {
    }

    @Override
    public void add(double delta, Unit unit) {
        this.add(this.key.getRole().getUnit().convert(delta, unit));
    }

    @Override
    public AtomicInteger currentConcurrency() {
        return this.concurrency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConcurrency(int concurrency) {
        if (concurrency > this.maxConcurrency) {
            Lock workLock = this.lock.writeLock();
            workLock.lock();
            try {
                this.maxConcurrency = concurrency;
            }
            finally {
                workLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxConcurrency() {
        Lock workLock = this.lock.readLock();
        workLock.lock();
        try {
            int n = this.maxConcurrency;
            return n;
        }
        finally {
            workLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMax() {
        Lock workLock = this.lock.readLock();
        workLock.lock();
        try {
            double d = this.statistics.getMax();
            return d;
        }
        finally {
            workLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMin() {
        Lock workLock = this.lock.readLock();
        workLock.lock();
        try {
            double d = this.statistics.getMin();
            return d;
        }
        finally {
            workLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getHits() {
        Lock workLock = this.lock.readLock();
        workLock.lock();
        try {
            long l = this.statistics.getN();
            return l;
        }
        finally {
            workLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getSum() {
        Lock workLock = this.lock.readLock();
        workLock.lock();
        try {
            double d = this.statistics.getSum();
            return d;
        }
        finally {
            workLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getStandardDeviation() {
        Lock workLock = this.lock.readLock();
        workLock.lock();
        try {
            double d = Math.sqrt(this.statistics.getVariance());
            return d;
        }
        finally {
            workLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getVariance() {
        Lock workLock = this.lock.readLock();
        workLock.lock();
        try {
            double d = this.statistics.getVariance();
            return d;
        }
        finally {
            workLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMean() {
        Lock workLock = this.lock.readLock();
        workLock.lock();
        try {
            double d = this.statistics.getMean();
            return d;
        }
        finally {
            workLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getSecondMoment() {
        Lock workLock = this.lock.readLock();
        workLock.lock();
        try {
            double d = this.statistics.getSecondMoment();
            return d;
        }
        finally {
            workLock.unlock();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!Counter.class.isInstance(o)) {
            return false;
        }
        Counter that = (Counter)Counter.class.cast(o);
        return this.key.equals(that.getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

