/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.tracking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.configuration.ioc.Destroying;
import org.apache.sirona.configuration.ioc.IoCs;
import org.apache.sirona.spi.Order;
import org.apache.sirona.spi.SPI;
import org.apache.sirona.store.DataStoreFactory;
import org.apache.sirona.store.tracking.PathTrackingDataStore;
import org.apache.sirona.tracking.Context;
import org.apache.sirona.tracking.PathTrackingEntry;
import org.apache.sirona.tracking.PathTrackingInformation;
import org.apache.sirona.tracking.PathTrackingInvocationListener;

public class PathTracker {
    private static final String NODE;
    private static final PathTrackingDataStore PATH_TRACKING_DATA_STORE;
    private static final ThreadLocal<Context> THREAD_LOCAL;
    private final PathTrackingInformation pathTrackingInformation;
    private static final boolean USE_EXECUTORS;
    private static boolean USE_SINGLE_STORE;
    protected static ExecutorService EXECUTORSERVICE;
    private static PathTrackingInvocationListener[] LISTENERS;

    public static PathTrackingInvocationListener[] getPathTrackingInvocationListeners() {
        return LISTENERS;
    }

    private PathTracker(PathTrackingInformation pathTrackingInformation) {
        this.pathTrackingInformation = pathTrackingInformation;
    }

    private static void cleanUp() {
        THREAD_LOCAL.remove();
    }

    public static PathTracker start(PathTrackingInformation pathTrackingInformation) {
        Context context = THREAD_LOCAL.get();
        int level = 0;
        PathTrackingInformation current = context.getPathTrackingInformation();
        if (current == null) {
            level = context.getLevel().incrementAndGet();
            pathTrackingInformation.setLevel(level);
        } else if (current != pathTrackingInformation) {
            level = context.getLevel().incrementAndGet();
            pathTrackingInformation.setLevel(level);
            pathTrackingInformation.setParent(current);
        }
        pathTrackingInformation.setStart(System.nanoTime());
        context.setPathTrackingInformation(pathTrackingInformation);
        for (PathTrackingInvocationListener listener : LISTENERS) {
            if (level == 1) {
                listener.startPath(context);
                continue;
            }
            listener.enterMethod(context);
        }
        return new PathTracker(pathTrackingInformation);
    }

    public void stop() {
        long end = System.nanoTime();
        long start = this.pathTrackingInformation.getStart();
        final Context context = THREAD_LOCAL.get();
        String uuid = context.getUuid();
        PathTrackingInformation current = context.getPathTrackingInformation();
        if (this.pathTrackingInformation != current) {
            context.getLevel().decrementAndGet();
            context.setPathTrackingInformation(this.pathTrackingInformation.getParent());
        }
        if (context.getPathTrackingInformation() != null) {
            for (PathTrackingInvocationListener listener : LISTENERS) {
                listener.exitMethod(context);
            }
        }
        PathTrackingEntry pathTrackingEntry = new PathTrackingEntry(uuid, NODE, this.pathTrackingInformation.getClassName(), this.pathTrackingInformation.getMethodName(), start, end - start, this.pathTrackingInformation.getLevel());
        if (USE_SINGLE_STORE) {
            PATH_TRACKING_DATA_STORE.store(pathTrackingEntry);
        } else {
            context.getEntries().add(pathTrackingEntry);
        }
        if (this.pathTrackingInformation.getLevel() == 1 && this.pathTrackingInformation.getParent() == null) {
            if (!USE_SINGLE_STORE) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        PATH_TRACKING_DATA_STORE.store(context.getEntries());
                        PathTracker.cleanUp();
                    }
                };
                if (USE_EXECUTORS) {
                    EXECUTORSERVICE.submit(runnable);
                } else {
                    runnable.run();
                }
            }
            for (PathTrackingInvocationListener listener : LISTENERS) {
                listener.endPath(context);
            }
        }
    }

    @Destroying
    public void destroy() {
        PathTracker.shutdown();
    }

    public static void shutdown() {
        EXECUTORSERVICE.shutdownNow();
    }

    static {
        ClassLoader classLoader;
        NODE = Configuration.getProperty("org.apache.sirona.javaagent.path.tracking.marker", Configuration.getProperty("org.apache.sirona.cube.CubeBuilder.marker", "node"));
        PATH_TRACKING_DATA_STORE = IoCs.findOrCreateInstance(DataStoreFactory.class).getPathTrackingDataStore();
        THREAD_LOCAL = new ThreadLocal<Context>(){

            @Override
            protected Context initialValue() {
                return new Context();
            }
        };
        USE_EXECUTORS = Boolean.parseBoolean(Configuration.getProperty("org.apache.sirona.pathtracking.useexecutors", "false"));
        USE_SINGLE_STORE = Boolean.parseBoolean(Configuration.getProperty("org.apache.sirona.pathtracking.singlestore", "false"));
        if (USE_EXECUTORS) {
            int threadsNumber = Configuration.getInteger("org.apache.sirona.pathtracking.executors", 5);
            EXECUTORSERVICE = Executors.newFixedThreadPool(threadsNumber);
        }
        if ((classLoader = PathTracker.class.getClassLoader()) == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        ArrayList<PathTrackingInvocationListener> listeners = new ArrayList<PathTrackingInvocationListener>();
        Iterator<PathTrackingInvocationListener> iterator = SPI.INSTANCE.find(PathTrackingInvocationListener.class, classLoader).iterator();
        while (iterator.hasNext()) {
            try {
                listeners.add(IoCs.autoSet(iterator.next()));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Collections.sort(listeners, ListenerComparator.INSTANCE);
        LISTENERS = listeners.toArray(new PathTrackingInvocationListener[listeners.size()]);
    }

    private static class ListenerComparator
    implements Comparator<PathTrackingInvocationListener> {
        private static final ListenerComparator INSTANCE = new ListenerComparator();

        private ListenerComparator() {
        }

        @Override
        public int compare(PathTrackingInvocationListener o1, PathTrackingInvocationListener o2) {
            Order order1 = o1.getClass().getAnnotation(Order.class);
            Order order2 = o2.getClass().getAnnotation(Order.class);
            if (order2 == null) {
                return -1;
            }
            if (order1 == null) {
                return 1;
            }
            return order1.value() - order2.value();
        }
    }
}

