/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.web.discovery;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.sirona.Role;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.gauges.Gauge;
import org.apache.sirona.web.servlet.StatusGauge;

public class GaugeDiscoveryListener
implements ServletContextListener {
    public static final String STATUS_GAUGES_ATTRIBUTE = "status-gauges";
    private static final int[] DEFAULT_STATUSES = new int[]{200, 201, 204, 400, 301, 302, 403, 404, 500};
    private Gauge.LoaderHelper helper;

    public void contextInitialized(ServletContextEvent sce) {
        String prefixesStr;
        ConcurrentHashMap<Integer, StatusGauge> gauges = new ConcurrentHashMap<Integer, StatusGauge>(35);
        if ("true".equalsIgnoreCase((String)sce.getServletContext().getAttribute("org.apache.sirona.web.monitored-status"))) {
            String monitoredStatuses = sce.getServletContext().getInitParameter("org.apache.sirona.web.monitored-statuses");
            String contextPath = sce.getServletContext().getContextPath();
            if (contextPath == null || contextPath.isEmpty()) {
                contextPath = "/";
            }
            if (monitoredStatuses == null) {
                for (int status : DEFAULT_STATUSES) {
                    gauges.put(status, GaugeDiscoveryListener.statusGauge(contextPath, gauges, status));
                }
            } else {
                for (String status : monitoredStatuses.split(",")) {
                    int statusInt = Integer.parseInt(status.trim());
                    gauges.put(statusInt, GaugeDiscoveryListener.statusGauge(contextPath, gauges, statusInt));
                }
            }
            sce.getServletContext().setAttribute(STATUS_GAUGES_ATTRIBUTE, gauges);
        }
        String[] prefixes = (prefixesStr = sce.getServletContext().getInitParameter("monitoring.discovery.packages")) != null ? prefixesStr.split(",") : null;
        this.helper = new Gauge.LoaderHelper("true".equals(sce.getServletContext().getInitParameter("monitoring.discovery.exclude-parent")), gauges.values(), prefixes);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.helper != null) {
            this.helper.destroy();
        }
    }

    private static StatusGauge statusGauge(String prefix, ConcurrentMap<Integer, StatusGauge> gauges, int status) {
        StatusGauge gauge = (StatusGauge)gauges.get(status);
        if (gauge != null) {
            return gauge;
        }
        StatusGauge newGauge = new StatusGauge(new Role(prefix + "-HTTP-" + Integer.toString(status), Unit.UNARY));
        StatusGauge old = gauges.putIfAbsent(status, newGauge);
        if (old != null) {
            return old;
        }
        return newGauge;
    }
}

