/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.store.status;

import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sirona.alert.AlertListener;
import org.apache.sirona.alert.AlerterSupport;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.configuration.ioc.Destroying;
import org.apache.sirona.store.BatchFuture;
import org.apache.sirona.store.status.CollectorNodeStatusDataStore;
import org.apache.sirona.util.DaemonThreadFactory;

public abstract class CollectorBaseNodeStatusDataStore
implements CollectorNodeStatusDataStore {
    private final AlerterSupport listeners = new AlerterSupport();
    private final AtomicReference<BatchFuture> scheduledTask = new AtomicReference();

    @Destroying
    public void shutdown() {
        BatchFuture task = this.scheduledTask.get();
        if (task != null) {
            task.done();
            this.scheduledTask.compareAndSet(task, null);
        }
    }

    public void reset() {
        this.shutdown();
    }

    public void addAlerter(AlertListener listener) {
        BatchFuture update;
        this.listeners.addAlerter(listener);
        if (this.scheduledTask.get() == null && !this.scheduledTask.compareAndSet(null, update = this.startTask())) {
            update.done();
        }
    }

    public void removeAlerter(AlertListener listener) {
        this.listeners.removeAlerter(listener);
        if (!this.listeners.hasAlerter()) {
            this.shutdown();
        }
    }

    private BatchFuture startTask() {
        String name = this.getClass().getSimpleName().toLowerCase(Locale.ENGLISH).replace("nodestatusdatastore", "");
        long period = this.getPeriod(name);
        ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory(name + "-status-alert-schedule-"));
        ScheduledFuture<?> future = ses.scheduleAtFixedRate(new CheckStatus(), period, period, TimeUnit.MILLISECONDS);
        return new BatchFuture(ses, future);
    }

    protected int getPeriod(String name) {
        return Configuration.getInteger((String)("org.apache.sirona." + name + ".status.period"), (int)Configuration.getInteger((String)("org.apache.sirona." + name + ".period"), (int)60000));
    }

    private class CheckStatus
    implements Runnable {
        private final Logger logger = Logger.getLogger(CheckStatus.class.getName());

        private CheckStatus() {
        }

        public void run() {
            try {
                CollectorBaseNodeStatusDataStore.this.listeners.notify(CollectorBaseNodeStatusDataStore.this.statuses());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

