/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.factory.javassist;

import [Ljava.lang.reflect.Method;;
import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import org.apache.commons.proxy.Interceptor;
import org.apache.commons.proxy.Invoker;
import org.apache.commons.proxy.ObjectProvider;
import org.apache.commons.proxy.exception.ProxyFactoryException;
import org.apache.commons.proxy.factory.javassist.JavassistInvocation;
import org.apache.commons.proxy.factory.javassist.JavassistUtils;
import org.apache.commons.proxy.factory.util.AbstractProxyClassGenerator;
import org.apache.commons.proxy.factory.util.AbstractSubclassingProxyFactory;
import org.apache.commons.proxy.factory.util.ProxyClassCache;

public class JavassistProxyFactory
extends AbstractSubclassingProxyFactory {
    private static final ProxyClassCache delegatingProxyClassCache = new ProxyClassCache(new DelegatingProxyClassGenerator());
    private static final ProxyClassCache interceptorProxyClassCache = new ProxyClassCache(new InterceptorProxyClassGenerator());
    private static final ProxyClassCache invocationHandlerProxyClassCache = new ProxyClassCache(new InvokerProxyClassGenerator());

    public Object createDelegatorProxy(ClassLoader classLoader, ObjectProvider targetProvider, Class[] proxyClasses) {
        try {
            Class clazz = delegatingProxyClassCache.getProxyClass(classLoader, proxyClasses);
            return clazz.getConstructor(ObjectProvider.class).newInstance(targetProvider);
        }
        catch (Exception e) {
            throw new ProxyFactoryException("Unable to instantiate proxy from generated proxy class.", e);
        }
    }

    public Object createInterceptorProxy(ClassLoader classLoader, Object target, Interceptor interceptor, Class[] proxyClasses) {
        try {
            Class clazz = interceptorProxyClassCache.getProxyClass(classLoader, proxyClasses);
            Method[] methods = AbstractProxyClassGenerator.getImplementationMethods(proxyClasses);
            return clazz.getConstructor(Method;.class, Object.class, Interceptor.class).newInstance(methods, target, interceptor);
        }
        catch (Exception e) {
            throw new ProxyFactoryException("Unable to instantiate proxy class instance.", e);
        }
    }

    public Object createInvokerProxy(ClassLoader classLoader, Invoker invoker, Class[] proxyClasses) {
        try {
            Class clazz = invocationHandlerProxyClassCache.getProxyClass(classLoader, proxyClasses);
            Method[] methods = AbstractProxyClassGenerator.getImplementationMethods(proxyClasses);
            return clazz.getConstructor(Method;.class, Invoker.class).newInstance(methods, invoker);
        }
        catch (Exception e) {
            throw new ProxyFactoryException("Unable to instantiate proxy from generated proxy class.", e);
        }
    }

    private static class DelegatingProxyClassGenerator
    extends AbstractProxyClassGenerator {
        private DelegatingProxyClassGenerator() {
        }

        public Class generateProxyClass(ClassLoader classLoader, Class[] proxyClasses) {
            try {
                CtClass proxyClass = JavassistUtils.createClass(AbstractSubclassingProxyFactory.getSuperclass(proxyClasses));
                JavassistUtils.addField(class$org$apache$commons$proxy$ObjectProvider == null ? (class$org$apache$commons$proxy$ObjectProvider = JavassistProxyFactory.class$("org.apache.commons.proxy.ObjectProvider")) : class$org$apache$commons$proxy$ObjectProvider, "provider", proxyClass);
                CtConstructor proxyConstructor = new CtConstructor(JavassistUtils.resolve(new Class[]{class$org$apache$commons$proxy$ObjectProvider == null ? (class$org$apache$commons$proxy$ObjectProvider = JavassistProxyFactory.class$("org.apache.commons.proxy.ObjectProvider")) : class$org$apache$commons$proxy$ObjectProvider}), proxyClass);
                proxyConstructor.setBody("{ this.provider = $1; }");
                proxyClass.addConstructor(proxyConstructor);
                JavassistUtils.addInterfaces(proxyClass, JavassistProxyFactory.toInterfaces(proxyClasses));
                Method[] methods = DelegatingProxyClassGenerator.getImplementationMethods(proxyClasses);
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    CtMethod ctMethod = new CtMethod(JavassistUtils.resolve(method.getReturnType()), method.getName(), JavassistUtils.resolve(method.getParameterTypes()), proxyClass);
                    String body = "{ return ( $r ) ( ( " + method.getDeclaringClass().getName() + " )provider.getObject() )." + method.getName() + "($$); }";
                    ctMethod.setBody(body);
                    proxyClass.addMethod(ctMethod);
                }
                return proxyClass.toClass(classLoader);
            }
            catch (CannotCompileException e) {
                throw new ProxyFactoryException("Could not compile class.", e);
            }
        }
    }

    private static class InterceptorProxyClassGenerator
    extends AbstractProxyClassGenerator {
        private InterceptorProxyClassGenerator() {
        }

        public Class generateProxyClass(ClassLoader classLoader, Class[] proxyClasses) {
            try {
                CtClass proxyClass = JavassistUtils.createClass(AbstractSubclassingProxyFactory.getSuperclass(proxyClasses));
                Method[] methods = InterceptorProxyClassGenerator.getImplementationMethods(proxyClasses);
                JavassistUtils.addInterfaces(proxyClass, JavassistProxyFactory.toInterfaces(proxyClasses));
                JavassistUtils.addField(array$Ljava$lang$reflect$Method == null ? (array$Ljava$lang$reflect$Method = JavassistProxyFactory.class$("[Ljava.lang.reflect.Method;")) : array$Ljava$lang$reflect$Method, "methods", proxyClass);
                JavassistUtils.addField(class$java$lang$Object == null ? (class$java$lang$Object = JavassistProxyFactory.class$("java.lang.Object")) : class$java$lang$Object, "target", proxyClass);
                JavassistUtils.addField(class$org$apache$commons$proxy$Interceptor == null ? (class$org$apache$commons$proxy$Interceptor = JavassistProxyFactory.class$("org.apache.commons.proxy.Interceptor")) : class$org$apache$commons$proxy$Interceptor, "interceptor", proxyClass);
                CtConstructor proxyConstructor = new CtConstructor(JavassistUtils.resolve(new Class[]{array$Ljava$lang$reflect$Method == null ? (array$Ljava$lang$reflect$Method = JavassistProxyFactory.class$("[Ljava.lang.reflect.Method;")) : array$Ljava$lang$reflect$Method, class$java$lang$Object == null ? (class$java$lang$Object = JavassistProxyFactory.class$("java.lang.Object")) : class$java$lang$Object, class$org$apache$commons$proxy$Interceptor == null ? (class$org$apache$commons$proxy$Interceptor = JavassistProxyFactory.class$("org.apache.commons.proxy.Interceptor")) : class$org$apache$commons$proxy$Interceptor}), proxyClass);
                proxyConstructor.setBody("{\n\tthis.methods = $1;\n\tthis.target = $2;\n\tthis.interceptor = $3; }");
                proxyClass.addConstructor(proxyConstructor);
                for (int i = 0; i < methods.length; ++i) {
                    CtMethod method = new CtMethod(JavassistUtils.resolve(methods[i].getReturnType()), methods[i].getName(), JavassistUtils.resolve(methods[i].getParameterTypes()), proxyClass);
                    Class invocationClass = JavassistInvocation.getMethodInvocationClass(classLoader, methods[i]);
                    String body = "{\n\t return ( $r ) interceptor.intercept( new " + invocationClass.getName() + "( methods[" + i + "], target, $args ) );\n }";
                    method.setBody(body);
                    proxyClass.addMethod(method);
                }
                return proxyClass.toClass(classLoader);
            }
            catch (CannotCompileException e) {
                throw new ProxyFactoryException("Could not compile class.", e);
            }
        }
    }

    private static class InvokerProxyClassGenerator
    extends AbstractProxyClassGenerator {
        private InvokerProxyClassGenerator() {
        }

        public Class generateProxyClass(ClassLoader classLoader, Class[] proxyClasses) {
            try {
                CtClass proxyClass = JavassistUtils.createClass(AbstractSubclassingProxyFactory.getSuperclass(proxyClasses));
                Method[] methods = InvokerProxyClassGenerator.getImplementationMethods(proxyClasses);
                JavassistUtils.addInterfaces(proxyClass, JavassistProxyFactory.toInterfaces(proxyClasses));
                JavassistUtils.addField(array$Ljava$lang$reflect$Method == null ? (array$Ljava$lang$reflect$Method = JavassistProxyFactory.class$("[Ljava.lang.reflect.Method;")) : array$Ljava$lang$reflect$Method, "methods", proxyClass);
                JavassistUtils.addField(class$org$apache$commons$proxy$Invoker == null ? (class$org$apache$commons$proxy$Invoker = JavassistProxyFactory.class$("org.apache.commons.proxy.Invoker")) : class$org$apache$commons$proxy$Invoker, "invoker", proxyClass);
                CtConstructor proxyConstructor = new CtConstructor(JavassistUtils.resolve(new Class[]{array$Ljava$lang$reflect$Method == null ? (array$Ljava$lang$reflect$Method = JavassistProxyFactory.class$("[Ljava.lang.reflect.Method;")) : array$Ljava$lang$reflect$Method, class$org$apache$commons$proxy$Invoker == null ? (class$org$apache$commons$proxy$Invoker = JavassistProxyFactory.class$("org.apache.commons.proxy.Invoker")) : class$org$apache$commons$proxy$Invoker}), proxyClass);
                proxyConstructor.setBody("{\n\tthis.methods = $1;\n\tthis.invoker = $2; }");
                proxyClass.addConstructor(proxyConstructor);
                for (int i = 0; i < methods.length; ++i) {
                    CtMethod method = new CtMethod(JavassistUtils.resolve(methods[i].getReturnType()), methods[i].getName(), JavassistUtils.resolve(methods[i].getParameterTypes()), proxyClass);
                    String body = "{\n\t return ( $r ) invoker.invoke( this, methods[" + i + "], $args );\n }";
                    method.setBody(body);
                    proxyClass.addMethod(method);
                }
                return proxyClass.toClass(classLoader);
            }
            catch (CannotCompileException e) {
                throw new ProxyFactoryException("Could not compile class.", e);
            }
        }
    }
}

