/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.interceptor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.proxy.Interceptor;
import org.apache.commons.proxy.Invocation;

public class SerializingInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] arguments = invocation.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = this.serializedCopy(arguments[i]);
        }
        return this.serializedCopy(invocation.proceed());
    }

    private Object serializedCopy(Object original) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(original);
            oout.close();
            bout.close();
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            ObjectInputStream oin = new ObjectInputStream(bin);
            Object copy = oin.readObject();
            oin.close();
            bin.close();
            return copy;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to make serialized copy of " + original.getClass().getName() + " object.", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to make serialized copy of " + original.getClass().getName() + " object.", e);
        }
    }
}

