/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.store.memory.counter;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.configuration.ioc.Destroying;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.counters.DefaultCounter;
import org.apache.sirona.counters.MetricData;
import org.apache.sirona.counters.OptimizedStatistics;
import org.apache.sirona.counters.jmx.CounterJMX;
import org.apache.sirona.gauges.Gauge;
import org.apache.sirona.gauges.counter.CounterGauge;
import org.apache.sirona.repositories.Repository;
import org.apache.sirona.store.counter.CounterDataStore;

public class InMemoryCounterDataStore
implements CounterDataStore {
    protected final boolean gauged = Configuration.is((String)"org.apache.sirona.counter.with-gauge", (boolean)false);
    protected final boolean jmx = Configuration.is((String)"org.apache.sirona.counter.with-jmx", (boolean)false);
    protected final ConcurrentMap<Counter.Key, Counter> counters = this.newCounterMap();
    protected final ConcurrentMap<Counter.Key, Collection<Gauge>> gauges = new ConcurrentHashMap<Counter.Key, Collection<Gauge>>();
    protected final ReadWriteLock stateLock = new ReentrantReadWriteLock();

    protected ConcurrentMap<Counter.Key, Counter> newCounterMap() {
        return new ConcurrentHashMap<Counter.Key, Counter>(50);
    }

    protected Counter newCounter(Counter.Key key) {
        return new DefaultCounter(key, (CounterDataStore)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter getOrCreateCounter(Counter.Key key) {
        Counter counter;
        block10: {
            counter = (Counter)this.counters.get(key);
            if (counter == null) {
                Lock lock = this.stateLock.readLock();
                lock.lock();
                try {
                    counter = this.newCounter(key);
                    Counter previous = this.counters.putIfAbsent(key, counter);
                    if (previous != null) {
                        counter = previous;
                        break block10;
                    }
                    if (this.gauged) {
                        Values values = new Values(counter);
                        ArrayList<SyncCounterGauge> counterGauges = new ArrayList<SyncCounterGauge>(3);
                        counterGauges.add(new SyncCounterGauge(counter, MetricData.Sum, values));
                        counterGauges.add(new SyncCounterGauge(counter, MetricData.Max, values));
                        counterGauges.add(new SyncCounterGauge(counter, MetricData.Hits, values));
                        for (Gauge gauge : counterGauges) {
                            Repository.INSTANCE.addGauge(gauge);
                        }
                        this.gauges.putIfAbsent(key, counterGauges);
                    }
                    if (!this.jmx) break block10;
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    try {
                        ObjectName objectName = new ObjectName("org.apache.sirona.counter:role=" + InMemoryCounterDataStore.escapeJmx(key.getRole().getName()) + ",name=" + InMemoryCounterDataStore.escapeJmx(key.getName()));
                        ((DefaultCounter)DefaultCounter.class.cast(counter)).setJmx(objectName);
                        if (!server.isRegistered(objectName)) {
                            server.registerMBean(new CounterJMX(counter), objectName);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return counter;
    }

    private static String escapeJmx(String name) {
        return name.replace('=', '_').replace(',', '_');
    }

    @Destroying
    public void cleanUp() {
        this.clearCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCounters() {
        Lock lock = this.stateLock.writeLock();
        lock.lock();
        try {
            if (this.jmx) {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                for (Counter counter : this.counters.values()) {
                    try {
                        server.unregisterMBean(((DefaultCounter)DefaultCounter.class.cast(counter)).getJmx());
                    }
                    catch (Exception exception) {}
                }
            }
            this.counters.clear();
            ConcurrentMap<Counter.Key, Collection<Gauge>> concurrentMap = this.gauges;
            synchronized (concurrentMap) {
                for (Collection list : this.gauges.values()) {
                    for (Gauge g : list) {
                        Repository.INSTANCE.stopGauge(g);
                    }
                    list.clear();
                }
                this.gauges.clear();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public Collection<Counter> getCounters() {
        return this.counters.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCounter(Counter counter, double delta) {
        if (!DefaultCounter.class.isInstance(counter)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports " + DefaultCounter.class.getName());
        }
        DefaultCounter defaultCounter = (DefaultCounter)DefaultCounter.class.cast(counter);
        Lock lock = defaultCounter.getLock().writeLock();
        lock.lock();
        try {
            defaultCounter.addInternal(delta);
        }
        finally {
            lock.unlock();
        }
    }

    private static class Values {
        private double max;
        private double sum;
        private double hits;
        private int called = -1;
        private final Counter counter;

        private Values(Counter counter) {
            this.counter = counter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void take() {
            if (this.called == 3 || this.called == -1) {
                DefaultCounter defaultCounter = (DefaultCounter)DefaultCounter.class.cast(this.counter);
                Lock lock = defaultCounter.getLock().writeLock();
                lock.lock();
                try {
                    OptimizedStatistics statistics = defaultCounter.getStatistics();
                    this.max = statistics.getMax();
                    this.sum = statistics.getSum();
                    this.hits = statistics.getN();
                    this.counter.reset();
                }
                finally {
                    lock.unlock();
                }
                this.called = 0;
            }
            ++this.called;
        }

        public double getMax() {
            return this.max;
        }

        public double getSum() {
            return this.sum;
        }

        public double getHits() {
            return this.hits;
        }
    }

    private static class SyncCounterGauge
    extends CounterGauge {
        private final Values values;

        private SyncCounterGauge(Counter counter, MetricData metric, Values values) {
            super(counter, metric);
            this.values = values;
        }

        public double value() {
            this.values.take();
            if (MetricData.Hits == this.metric) {
                return this.values.getHits();
            }
            if (MetricData.Sum == this.metric) {
                return this.values.getSum();
            }
            if (MetricData.Max == this.metric) {
                return this.values.getMax();
            }
            throw new IllegalArgumentException(this.metric.name());
        }
    }
}

