/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.store.memory.counter;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.sirona.Role;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.counters.DefaultCounter;
import org.apache.sirona.gauges.Gauge;
import org.apache.sirona.repositories.Repository;
import org.apache.sirona.store.counter.CounterDataStore;
import org.apache.sirona.store.memory.counter.InMemoryCounterDataStore;

public class LimitedInMemoryCounterDataStore
extends InMemoryCounterDataStore {
    private static final int MAX_SIZE = Configuration.getInteger((String)"org.apache.sirona.counter.max-size", (int)1000);
    private static final boolean ONLY_EVICT_WEB_COUNTERS = Boolean.parseBoolean(Configuration.getProperty((String)"org.apache.sirona.counter.evict-web-only", (String)"true"));
    private static final double EVITION_RATIO = Double.parseDouble(Configuration.getProperty((String)"org.apache.sirona.counter.evition.ratio", (String)"0.25"));

    @Override
    protected ConcurrentMap<Counter.Key, Counter> newCounterMap() {
        return new FixedSizedMap();
    }

    @Override
    protected Counter newCounter(Counter.Key key) {
        if (ONLY_EVICT_WEB_COUNTERS) {
            if (Role.WEB.equals((Object)key.getRole())) {
                return new DefaultCounterTimestamped(key, this);
            }
            return super.newCounter(key);
        }
        return new DefaultCounterTimestamped(key, this);
    }

    private static class DefaultCounterTimestamped
    extends DefaultCounter {
        private volatile long timestamp = System.currentTimeMillis();

        public DefaultCounterTimestamped(Counter.Key key, CounterDataStore store) {
            super(key, store);
        }

        public void add(double delta) {
            super.add(delta);
            this.timestamp = System.currentTimeMillis();
        }
    }

    protected class FixedSizedMap
    extends ConcurrentSkipListMap<Counter.Key, Counter> {
        protected FixedSizedMap() {
            super(new Comparator<Counter.Key>(){

                @Override
                public int compare(Counter.Key o1, Counter.Key o2) {
                    int role = o1.getRole().compareTo(o2.getRole());
                    if (role == 0) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return role;
                }
            });
        }

        @Override
        public Counter put(Counter.Key key, Counter value) {
            if (this.size() >= MAX_SIZE) {
                this.evict();
            }
            return super.put(key, value);
        }

        @Override
        public Counter putIfAbsent(Counter.Key key, Counter value) {
            if (this.size() >= MAX_SIZE) {
                this.evict();
            }
            return super.putIfAbsent(key, value);
        }

        private synchronized void evict() {
            if (this.size() < MAX_SIZE) {
                return;
            }
            int size = this.size();
            int toEvict = (int)((double)size * EVITION_RATIO);
            ArrayList entries = new ArrayList(size);
            for (Map.Entry entry : this.entrySet()) {
                entries.add(entry);
                if (entries.size() < size) continue;
                break;
            }
            Collections.sort(entries, new Comparator<Map.Entry<Counter.Key, Counter>>(){

                @Override
                public int compare(Map.Entry<Counter.Key, Counter> o1, Map.Entry<Counter.Key, Counter> o2) {
                    boolean o1HasTimestamp = DefaultCounterTimestamped.class.isInstance(o1);
                    boolean o2hasTimestamp = DefaultCounterTimestamped.class.isInstance(o2);
                    if (!o1HasTimestamp && !o2hasTimestamp) {
                        return o1.getKey().getName().compareTo(o2.getKey().getName());
                    }
                    if (o1HasTimestamp && !o2hasTimestamp) {
                        return -1;
                    }
                    if (!o1HasTimestamp) {
                        return 1;
                    }
                    long hitDiff = ((DefaultCounterTimestamped)((Object)DefaultCounterTimestamped.class.cast(o1.getValue()))).timestamp - ((DefaultCounterTimestamped)((Object)DefaultCounterTimestamped.class.cast(o2.getValue()))).timestamp;
                    return (int)hitDiff;
                }
            });
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            for (Map.Entry entry : entries) {
                Collection g;
                boolean removed;
                Counter.Key key = (Counter.Key)entry.getKey();
                if (!DefaultCounterTimestamped.class.isInstance(entry.getValue()) || !(removed = this.remove(key) != null)) continue;
                if (LimitedInMemoryCounterDataStore.this.gauged && (g = (Collection)LimitedInMemoryCounterDataStore.this.gauges.remove(key)) != null) {
                    for (Gauge gauge : g) {
                        Repository.INSTANCE.stopGauge(gauge);
                    }
                }
                if (LimitedInMemoryCounterDataStore.this.jmx) {
                    try {
                        ObjectName objectName = ((DefaultCounter)DefaultCounter.class.cast(entry.getValue())).getJmx();
                        if (server.isRegistered(objectName)) {
                            server.unregisterMBean(objectName);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (toEvict-- > 0) continue;
                break;
            }
        }
    }
}

