/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.store.counter;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.apache.sirona.counters.AggregatedCounter;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.math.Aggregators;
import org.apache.sirona.store.counter.CollectorCounter;
import org.apache.sirona.store.counter.LeafCollectorCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedCollectorCounter
extends CollectorCounter
implements AggregatedCounter {
    private final ConcurrentMap<String, LeafCollectorCounter> aggregation = new ConcurrentHashMap<String, LeafCollectorCounter>(50);

    public AggregatedCollectorCounter(Counter.Key key) {
        super(key);
    }

    public AggregatedCollectorCounter(Counter.Key key, Map<String, LeafCollectorCounter> counters) {
        super(key);
        this.aggregation.putAll(counters);
        this.update();
    }

    public void update() {
        Lock workLock = this.lock.writeLock();
        workLock.lock();
        try {
            Collection<LeafCollectorCounter> counters = this.aggregation.values();
            this.statistics = Aggregators.aggregate(counters);
            this.concurrency.set(AggregatedCollectorCounter.computeConcurrency(counters));
            this.updateConcurrency(this.concurrency.get());
        }
        finally {
            workLock.unlock();
        }
    }

    public void addIfMissing(String marker, LeafCollectorCounter counter) {
        this.aggregation.putIfAbsent(marker, counter);
    }

    private static int computeConcurrency(Collection<LeafCollectorCounter> counters) {
        int i = 0;
        for (LeafCollectorCounter counter : counters) {
            i += counter.currentConcurrency().get();
        }
        return i;
    }

    @Override
    public Map<String, ? extends Counter> aggregated() {
        return this.aggregation;
    }
}

