/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SironaServiceLoader<S>
implements Iterable<S> {
    private Class<S> service;
    private ClassLoader loader;

    private SironaServiceLoader(Class<S> service, ClassLoader loader) {
        this.service = service;
        this.loader = loader;
    }

    public static <S> SironaServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return new SironaServiceLoader<S>(service, loader);
    }

    @Override
    @IgnoreJRERequirement
    public Iterator<S> iterator() {
        try {
            return ServiceLoader.load(this.service, this.loader).iterator();
        }
        catch (Throwable t) {
            return this.iterator1_5();
        }
    }

    public Iterator<S> iterator1_5() {
        String resourceName = "META-INF/services/" + this.service.getName();
        try {
            ArrayList<String> serviceNames = new ArrayList<String>();
            Enumeration<URL> urls = this.loader.getResources(resourceName);
            while (urls.hasMoreElements()) {
                serviceNames.addAll(this.parseFile(urls.nextElement()));
            }
            return this.initInstances(serviceNames).iterator();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> parseFile(URL url) throws IOException {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        ArrayList<String> classNames = new ArrayList<String>();
        try {
            inputStream = url.openStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            String line = bufferedReader.readLine();
            while (line != null) {
                if (!(line = line.trim()).startsWith("#") && line.length() > 0) {
                    classNames.add(line);
                }
                line = bufferedReader.readLine();
            }
            ArrayList<String> arrayList = classNames;
            return arrayList;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    private List<S> initInstances(List<String> classNames) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ArrayList instances = new ArrayList(classNames.size());
        for (String className : classNames) {
            Class<?> clazz = this.loader.loadClass(className);
            instances.add(clazz.newInstance());
        }
        return instances;
    }
}

