/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.skype.portlet;

import java.io.IOException;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webconferencing.Utils;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.skype.SkypeProvider;
import org.exoplatform.webui.application.WebuiRequestContext;

public class SkypeProviderPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(SkypeProviderPortlet.class);
    private WebConferencingService webConferencing;
    private SkypeProvider provider;

    public void init() throws PortletException {
        super.init();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.webConferencing = (WebConferencingService)container.getComponentInstanceOfType(WebConferencingService.class);
        try {
            this.provider = (SkypeProvider)this.webConferencing.getProvider("skype");
        }
        catch (ClassCastException e) {
            LOG.error((Object)("Provider skype isn't an instance of " + SkypeProvider.class.getName()), (Throwable)e);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.provider != null) {
            try {
                SkypeProvider.SkypeSettings settings = this.provider.settings().build();
                String settingsJson = Utils.asJSON((Object)settings);
                JavascriptManager js = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getJavascriptManager();
                js.require("SHARED/webConferencing", "webConferencing").require("SHARED/webConferencing_skype", "skypeProvider").addScripts("if (skypeProvider) { skypeProvider.configure(" + settingsJson + "); webConferencing.addProvider(skypeProvider); webConferencing.update(); }");
            }
            catch (Exception e) {
                LOG.error((Object)("Error processing Skype Calls portlet for user " + request.getRemoteUser()), (Throwable)e);
            }
        }
    }
}

