/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream.relevancy.domain;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="SmartActivityRelevanceStats")
@ExoEntity
@Table(name="ST_ACTIVITY_RELEVANCY")
@NamedQueries(value={@NamedQuery(name="SmartActivityRelevanceStats.findCount", query="SELECT COUNT(*) FROM SmartActivityRelevanceStats")})
@NamedNativeQueries(value={@NamedNativeQuery(name="SmartActivityRelevanceStats.findStats", query="SELECT user_id, (SELECT count(*) FROM st_activity_relevancy WHERE user_id = r.user_id AND IS_RELEVANT = 1) as relevant_count, (SELECT count(*) FROM st_activity_relevancy WHERE user_id = r.user_id AND IS_RELEVANT = 0) as irrelevant_count, (SELECT count(*) FROM st_activity_relevancy WHERE user_id = r.user_id AND IS_RELEVANT IS NULL) as neutral_count, MAX(r.update_date) as last_date FROM st_activity_relevancy r WHERE r.update_date > :afterDate GROUP BY r.user_id", resultClass=RelevanceStatsEntity.class)})
public class RelevanceStatsEntity {
    @Transient
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Id
    @Column(name="user_id")
    protected String userId;
    @Column(name="relevant_count")
    protected Long relevantCount;
    @Column(name="irrelevant_count")
    protected Long irrelevantCount;
    @Column(name="neutral_count")
    protected Long neutralCount;
    @Column(name="last_date")
    protected Date lastDate;

    public String getUserId() {
        return this.userId;
    }

    public Long getTotalCount() {
        return this.getRelevantCount() + this.getIrrelevantCount() + this.getNeutralCount();
    }

    public Long getRelevantCount() {
        return this.relevantCount;
    }

    public Long getIrrelevantCount() {
        return this.irrelevantCount;
    }

    public Long getNeutralCount() {
        return this.neutralCount;
    }

    public String getUpdateDate() {
        return this.dateFormat.format(this.lastDate);
    }

    public String toString() {
        return "RelevanceStatsEntity [userId=" + this.userId + ", lastDate=" + this.lastDate + "]";
    }
}

