/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream;

import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;
import javax.persistence.PersistenceException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.smartactivitystream.SmartActivityException;
import org.exoplatform.smartactivitystream.stats.dao.ActivityFocusDAO;
import org.exoplatform.smartactivitystream.stats.domain.ActivityFocusEntity;
import org.picocontainer.Startable;

public class SmartActivityService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(SmartActivityService.class);
    public static final String TRACKER_CACHE_NAME = "smartactivity.TrackerCache".intern();
    public static final int TRACKER_CACHE_PERIOD = 120000;
    protected final ExoCache<String, ActivityFocusEntity> trackerCache;
    protected final ActivityFocusDAO focusStorage;
    protected final Timer focusSaver = new Timer();
    protected boolean enableTrackers = false;

    public SmartActivityService(ActivityFocusDAO focusStorage, CacheService cacheService, InitParams params) {
        this.focusStorage = focusStorage;
        this.trackerCache = cacheService.getCacheInstance(TRACKER_CACHE_NAME);
        PropertiesParam param = params.getPropertiesParam("smartactivity-configuration");
        if (param != null) {
            String enableTrackers = (String)param.getProperties().get((Object)"enable-trackers");
            this.enableTrackers = enableTrackers != null ? Boolean.parseBoolean(enableTrackers.trim()) : true;
        }
    }

    public void submitActivityFocus(ActivityFocusEntity focus) throws SmartActivityException {
        String fkey = this.focusKey(focus);
        ActivityFocusEntity tracked = (ActivityFocusEntity)this.trackerCache.get((Serializable)((Object)fkey));
        if (tracked != null) {
            this.agregateFocus(tracked, focus);
            this.trackerCache.put((Serializable)((Object)fkey), (Object)tracked);
        } else {
            this.trackerCache.put((Serializable)((Object)fkey), (Object)focus);
        }
    }

    public boolean isTrackersEnabled() {
        return this.enableTrackers;
    }

    public void start() {
        final String containerName = ExoContainerContext.getCurrentContainer().getContext().getName();
        TimerTask saveTask = new TimerTask(){

            @Override
            public void run() {
                SmartActivityService.this.saveReadyCacheInContainerContext(containerName, true);
            }
        };
        this.focusSaver.schedule(saveTask, 240000L, 120000L);
    }

    public void stop() {
        this.saveReadyCacheInContainerContext(ExoContainerContext.getCurrentContainer().getContext().getName(), false);
    }

    protected String focusKey(ActivityFocusEntity focus) {
        return focus.getUserId() + focus.getActivityId();
    }

    protected void agregateFocus(ActivityFocusEntity existing, ActivityFocusEntity add) {
        if (add.getStopTime() > existing.getStopTime()) {
            existing.setStopTime(add.getStopTime());
        }
        existing.setTotalShown(this.sum(existing.getTotalShown(), add.getTotalShown()));
        existing.setContentShown(this.sum(existing.getContentShown(), add.getContentShown()));
        existing.setConvoShown(this.sum(existing.getConvoShown(), add.getConvoShown()));
        existing.setContentHits(this.sum(existing.getContentHits(), add.getContentHits()));
        existing.setConvoHits(this.sum(existing.getConvoHits(), add.getConvoHits()));
        existing.setAppHits(this.sum(existing.getAppHits(), add.getAppHits()));
        existing.setProfileHits(this.sum(existing.getProfileHits(), add.getProfileHits()));
        existing.setLinkHits(this.sum(existing.getLinkHits(), add.getLinkHits()));
    }

    protected Long sum(Long existing, Long add) {
        if (existing == null) {
            return add;
        }
        if (add == null) {
            return existing;
        }
        return existing + add;
    }

    protected void saveActivityFocus(ActivityFocusEntity focus) throws SmartActivityException {
        block4: {
            try {
                ActivityFocusEntity tracked = (ActivityFocusEntity)this.focusStorage.find(focus.getId());
                if (tracked == null) {
                    this.focusStorage.create(focus);
                    break block4;
                }
                if (tracked.getTrackerVersion().equals(focus.getTrackerVersion())) {
                    this.focusStorage.update(focus);
                    break block4;
                }
                LOG.warn((Object)("Cannot update activity focus of different tracker versions: " + tracked.getTrackerVersion() + " vs " + focus.getTrackerVersion()));
                throw new SmartActivityException("Cannot update activity focus of different tracker versions");
            }
            catch (PersistenceException e) {
                LOG.error("Failed to save activity focus {}:{}", new Object[]{focus.getUserId(), focus.getActivityId(), e});
                throw new SmartActivityException("Failed to save activity focus", e);
            }
        }
    }

    protected void saveTrackerCache(final boolean readyOnly) throws Exception {
        this.trackerCache.select((CachedObjectSelector)new CachedObjectSelector<String, ActivityFocusEntity>(){

            public boolean select(String key, ObjectCacheInfo<? extends ActivityFocusEntity> ocinfo) {
                if (readyOnly) {
                    ActivityFocusEntity f = (ActivityFocusEntity)ocinfo.get();
                    return f != null ? f.isReady() : false;
                }
                return true;
            }

            public void onSelect(ExoCache<? extends String, ? extends ActivityFocusEntity> cache, String key, ObjectCacheInfo<? extends ActivityFocusEntity> ocinfo) throws Exception {
                ActivityFocusEntity f = (ActivityFocusEntity)ocinfo.get();
                if (f != null) {
                    SmartActivityService.this.saveActivityFocus(f);
                    cache.remove((Serializable)((Object)key));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveReadyCacheInContainerContext(String containerName, boolean readyOnly) {
        ExoContainer exoContainer = ExoContainerContext.getContainerByName((String)containerName);
        if (exoContainer != null) {
            ExoContainer contextContainer = ExoContainerContext.getCurrentContainerIfPresent();
            try {
                ExoContainerContext.setCurrentContainer((ExoContainer)exoContainer);
                RequestLifeCycle.begin((ExoContainer)exoContainer);
                this.saveTrackerCache(readyOnly);
            }
            catch (Exception e) {
                LOG.error((Object)"Error saving trackers", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
                ExoContainerContext.setCurrentContainer((ExoContainer)contextContainer);
            }
        } else {
            LOG.warn((Object)("Container not found " + containerName + " for saving trackers"));
        }
    }
}

